-- Deploy gaia:api_20190401_bd_transfer to mysql

BEGIN;

CREATE TABLE `api_bdtransfermonth` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `month_at` date NOT NULL,
    `total_amount` double precision NOT NULL,
    `should_pay` double precision NOT NULL,
    `already_pay` double precision NOT NULL,
    `is_finished` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `doctor_id` varchar(100) NOT NULL
);
ALTER TABLE `api_bdtransfermonth` ADD CONSTRAINT `doctor_id_refs_id_f4ba1c70` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE TABLE `api_bdtransfermonthtobudan` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `bdtransfermonth_id` integer NOT NULL,
    `budan_id` varchar(12) NOT NULL,
    `has_paid` bool NOT NULL,
    `created_time` datetime(6) NOT NULL
);
ALTER TABLE `api_bdtransfermonthtobudan` ADD CONSTRAINT `bdtransfermonth_id_refs_id_3c4c4959` FOREIGN KEY (`bdtransfermonth_id`) REFERENCES `api_bdtransfermonth` (`id`);
ALTER TABLE `api_bdtransfermonthtobudan` ADD CONSTRAINT `budan_id_refs_id_0553ecf4` FOREIGN KEY (`budan_id`) REFERENCES `api_budan` (`id`);
CREATE TABLE `api_bdtransferapplyrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `created_time` datetime(6) NOT NULL,
    `pass_time` datetime(6),
    `total_amount` double precision NOT NULL,
    `should_pay` double precision NOT NULL,
    `status` integer NOT NULL,
    `doctor_id` varchar(100) NOT NULL,
    `reason` varchar(1000),
    `bdtransfermonth_id` integer NOT NULL
);
ALTER TABLE `api_bdtransferapplyrecord` ADD CONSTRAINT `doctor_id_refs_id_ded62a01` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
ALTER TABLE `api_bdtransferapplyrecord` ADD CONSTRAINT `bdtransfermonth_id_refs_id_1f363b47` FOREIGN KEY (`bdtransfermonth_id`) REFERENCES `api_bdtransfermonth` (`id`);
CREATE TABLE `api_bdtransferapplypic` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `bdtransferapplyrecord_id` integer NOT NULL,
    `content` varchar(300) NOT NULL,
    `image_type` integer NOT NULL
);
ALTER TABLE `api_bdtransferapplypic` ADD CONSTRAINT `bdtransferapplyrecord_id_refs_id_3c1fe9b2` FOREIGN KEY (`bdtransferapplyrecord_id`) REFERENCES `api_bdtransferapplyrecord` (`id`);
CREATE TABLE `api_bdtransfertobudan` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `bdtransferapplyrecord_id` integer NOT NULL,
    `budan_id` varchar(12) NOT NULL,
    `created_time` datetime(6) NOT NULL
);
ALTER TABLE `api_bdtransfertobudan` ADD CONSTRAINT `bdtransferapplyrecord_id_refs_id_858991fb` FOREIGN KEY (`bdtransferapplyrecord_id`) REFERENCES `api_bdtransferapplyrecord` (`id`);
ALTER TABLE `api_bdtransfertobudan` ADD CONSTRAINT `budan_id_refs_id_8e57cc40` FOREIGN KEY (`budan_id`) REFERENCES `api_budan` (`id`);

COMMIT;
