-- Deploy gaia:api_2019_04_28_add_homepage_feeds_and_new_tab to mysql

BEGIN;

CREATE TABLE `api_tab_operate_v2_tags` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `taboperatev2_id` integer NOT NULL,
    `tag_id` integer NOT NULL,
    UNIQUE (`taboperatev2_id`, `tag_id`)
)
;
ALTER TABLE `api_tab_operate_v2_tags` ADD CONSTRAINT `tag_id_refs_id_78f48155` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
CREATE TABLE `api_tab_operate_v2` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(16) NOT NULL,
    `rank` integer NOT NULL,
    `is_online` bool NOT NULL
)
;
ALTER TABLE `api_tab_operate_v2_tags` ADD CONSTRAINT `taboperatev2_id_refs_id_a3af2448` FOREIGN KEY (`taboperatev2_id`) REFERENCES `api_tab_operate_v2` (`id`);
CREATE TABLE `api_feedoperatev2_regions` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `feedoperatev2_id` integer NOT NULL,
    `region_id` integer NOT NULL,
    UNIQUE (`feedoperatev2_id`, `region_id`)
)
;
ALTER TABLE `api_feedoperatev2_regions` ADD CONSTRAINT `region_id_refs_id_595ff099` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`);
CREATE TABLE `api_feedoperatev2_cities` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `feedoperatev2_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL,
    UNIQUE (`feedoperatev2_id`, `city_id`)
)
;
ALTER TABLE `api_feedoperatev2_cities` ADD CONSTRAINT `city_id_refs_id_993fcaad` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);
CREATE TABLE `api_feedoperatev2` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(32) NOT NULL,
    `location` varchar(32) NOT NULL,
    `tab_id` varchar(16),
    `image` varchar(1024) NOT NULL,
    `service_type` varchar(2) NOT NULL,
    `card_type` varchar(32) NOT NULL,
    `card_id` varchar(32) NOT NULL,
    `user_type` varchar(2) NOT NULL,
    `payment_type` varchar(2) NOT NULL,
    `is_online` bool NOT NULL,
    `rank` integer NOT NULL,
    `width` integer NOT NULL,
    `height` integer NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_feedoperatev2_regions` ADD CONSTRAINT `feedoperatev2_id_refs_id_d363a636` FOREIGN KEY (`feedoperatev2_id`) REFERENCES `api_feedoperatev2` (`id`);
ALTER TABLE `api_feedoperatev2_cities` ADD CONSTRAINT `feedoperatev2_id_refs_id_8f8f3635` FOREIGN KEY (`feedoperatev2_id`) REFERENCES `api_feedoperatev2` (`id`);


CREATE INDEX `api_tab_operate_v2_tags_104b91dc` ON `api_tab_operate_v2_tags` (`taboperatev2_id`);
CREATE INDEX `api_tab_operate_v2_tags_5659cca2` ON `api_tab_operate_v2_tags` (`tag_id`);
CREATE INDEX `api_feedoperatev2_regions_01b37f40` ON `api_feedoperatev2_regions` (`feedoperatev2_id`);
CREATE INDEX `api_feedoperatev2_regions_55a4ce96` ON `api_feedoperatev2_regions` (`region_id`);
CREATE INDEX `api_feedoperatev2_cities_01b37f40` ON `api_feedoperatev2_cities` (`feedoperatev2_id`);
CREATE INDEX `api_feedoperatev2_cities_b376980e` ON `api_feedoperatev2_cities` (`city_id`);

COMMIT;
