# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

from . import typedef

import unittest


typedef_pragma_code = """
{-# Straight Configuration Alpha Typedef #-}

{- 输入参数 -}
data Input = {
    id: Int -- 帖子ID
}

{- 返回值 -}
data Output = {

    user: {
        id: Int          -- 用户ID
        username: String -- 用户名
        nickname: String -- 昵称
    } -- 作者信息

    {- 帖子信息 -}
    topic: {
        id:   Int       -- 帖子ID
        text: String    -- 正文
        create_time: UTCTimestamp -- 发帖时间

        {- 最后修改时间。
           如果没有修改过，则为空。-}
        last_modified_time: UTCTimestamp | None
    }

    replies: Array[{
        id:       Int    -- 回复ID
        replier:  Int    -- 回复者ID
        reply_t0: Int    -- 被回复者ID
        text:     String -- 回复正文
    }] -- 所有回复
}

{-# Straight End #-}
"""

type_pragma_code = """
{-# Straight Configuration Beta Type #-}
{
    {- 输入参数 -}
    input: {
        id: Int -- 帖子ID
    }

    {- 返回值 -}
    output: {
        user: {
            id: Int          -- 用户ID
            username: String -- 用户名
            nickname: String -- 昵称
        } -- 作者信息

        {- 帖子信息 -}
        topic: {
            id:   Int       -- 帖子ID
            text: String    -- 正文
            create_time: UTCTimestamp -- 发帖时间

            {- 最后修改时间。
               如果没有修改过，则为空。-}
            last_modified_time: UTCTimestamp | None
        }

        replies: Array[{
            id:       Int    -- 回复ID
            replier:  Int    -- 回复者ID
            reply_t0: Int    -- 被回复者ID
            text:     String -- 回复正文
        }] -- 所有回复
    }
}
{-# Straight End #-}
"""


class TestParse(unittest.TestCase):

    def test_type_pragma(self):
        tree = typedef.parse_type_pragma(type_pragma_code)

    def test_code_pragma(self):
        tree = typedef.parse_code_pragma(typedef_pragma_code)

