# coding=utf-8
from __future__ import print_function, unicode_literals, absolute_import


class AbstractView(object):
    def __init__(self, data_source, view_function):
        """
        currently, data_source is just a model wrapped by
        "injection.data_sync.core.django_data.DjangoDataSourceManager"

        when code must be seperated across services,
        data_source must be an object which describe its
        database, table, field(column), with foreign key relation on it
        (suppose one abstract view only concern one relation?)
        such data_source need not to be a MySQL table, but should be able to
        appropriately trigger change event through various data_source driver

        :param data_source:
        :param view_function: a callable which receives a list of PKs,
                               and return a list of objects,
                               where values are rows in the view
        """
        self.data_source = data_source
        self.view_function = view_function

    @classmethod
    def batch2single(cls, pk):
        """
        used by data_sync v1 to v2 migration
        :return:
        """
        pass


    @classmethod
    def rpccall2func(cls, api='_ping'):
        """
        helper to wrap an rpc api string to view function

        :param api: rpc api string
        :return:
        """
        return None
