# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from gm_types.gaia import DIARY_CONTENT_LEVEL

from .diary import Diary


class DiaryCheck(models.Model):
    """
    审核日记本
    """

    class Meta:
        verbose_name = u'审核日记本'
        db_table = 'api_diarycheck'
        app_label = 'talos'

    diary = models.ForeignKey(Diary, related_name='diary_check', verbose_name=u'关联日记本')
    person_id = models.UUIDField(editable=False, verbose_name=u'审核人外键id')
    check_time = models.DateTimeField(verbose_name=u'审核时间', auto_now_add=True)
    content_level = models.CharField(verbose_name=u'内容分级', max_length=8, choices=DIARY_CONTENT_LEVEL,
                                     default=DIARY_CONTENT_LEVEL.UNAUDITED)
    check_content = models.TextField(verbose_name=u'运营审核备注', null=True, blank=True, default='')
    title = models.CharField(max_length=128, verbose_name='消息标题', default='')
    send_message = models.TextField(verbose_name=u'发送短信信息', null=True, blank=True, default='')
