# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from .diary import Diary


class DiaryFavor(models.Model):
    class Meta:
        unique_together = ('user_id', 'diary')
        verbose_name = '日记本收藏'
        app_label = 'talos'
        db_table = 'api_diaryfavor'

    user_id = models.IntegerField(help_text=u'收藏者外键id')
    diary = models.ForeignKey(Diary, related_name='favor_diary_diary', help_text='收藏的日记本')
    created_time = models.DateTimeField(auto_now_add=True, verbose_name=u"收藏时间")
    is_deleted = models.BooleanField(default=False, help_text=u"是否已经删除")
