#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   16/03/30 19:28:46
#   Desc    :   生成短网址
#
from __future__ import absolute_import, division, with_statement

import json

import requests

from rpc.tool.log_tool import logging_exception


class DWZ(object):
    dwz = 'https://api.weibo.com/2/short_url/shorten.json'

    def make_dwz(self, long_url):
        try:
            req = requests.get(
                self.dwz,
                params={
                    "url_long": long_url,
                    "source": 209678993,
                    # source get from:
                    # http://www.cnblogs.com/onew/articles/5252203.html
                }
            )
            data = json.loads(req.content)
            if not data or 'urls' not in data:
                return ''

            data = data['urls'][0]
            return data['url_short']

        except Exception:
            logging_exception()
            return ''
