# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function


import six
import re
import django.db
import django.db.models


def blur(db_table, increment):
    assert isinstance(db_table, six.string_types)
    assert isinstance(increment, six.integer_types)

    db_table = str(db_table)
    assert re.match(r'^[^`]+$', db_table)

    with django.db.connection.cursor() as c:
        c.execute("SELECT MAX(`id`) FROM `{table}`".format(table=db_table))
        data = c.fetchall()
        assert len(data) == 1
        assert len(data[0]) == 1
        max_id = data[0][0]

        c.execute(
            "ALTER TABLE `{table}` AUTO_INCREMENT = %s".format(table=db_table),
            [max_id + increment],
        )




