#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   18/01/31 12:36:06
#   Desc    :   百科目录相关逻辑
#
from gm_types.wiki import DIRECTORY_TYPE, DIRECTORY_CELL_TYPE
from gm_types.wiki import ITEM_H1, DRUG_H1, MATERIAL_H1, MACHINE_H1


def directory_cell_info(directory):
    if directory.collect:
        cell_type = DIRECTORY_CELL_TYPE.COLLECT
        cell = directory.collect
    elif directory.brand:
        cell_type = DIRECTORY_CELL_TYPE.BRAND
        cell = directory.brand
    elif directory.product:
        cell_type = DIRECTORY_CELL_TYPE.PRODUCT
        cell = directory.product
    else:
        raise Exception
    if not cell.is_online:
        return {}

    model_name = {
        DIRECTORY_TYPE.ITEM: ITEM_H1,
        DIRECTORY_TYPE.DRUG: DRUG_H1,
        DIRECTORY_TYPE.MACHINE: MACHINE_H1,
        DIRECTORY_TYPE.MATERIAL: MATERIAL_H1
    }[directory.dirctory_type].getDesc(int(directory.model_type))

    return {
        'cell_id': cell.id,
        'cell_name': cell.name,
        'cell_type': cell_type,
        'model_name': model_name
    }
