# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from django.db.models import ForeignKey, IntegerField, CharField
from django.db.models import BooleanField, DateTimeField

from gm_types.wiki import DIRECTORY_TYPE, DIRECTORY_CELL_TYPE

from wiki.models.brand import Brand
from wiki.models.product import Product
from wiki.models.collect import Collect


class Directory(models.Model):
    class Meta:
        verbose_name = '百科目录'
        db_table = 'wiki_directory'

    dirctory_type = CharField(u'目录类型', max_length=20, choices=DIRECTORY_TYPE)
    model_type = CharField(u'模块类型', max_length=20)
    rank = IntegerField(u'顺序')
    brand = ForeignKey(Brand, null=True)
    product = ForeignKey(Product, null=True)
    collect = ForeignKey(Collect, null=True)
    is_online = BooleanField('是否上线', default=True)
