# -*- coding:utf-8 -*-
'''
记录第三方信息
'''

from gm_types.gaia import TEMP_ACTIVITY_TYPE

from rpc.decorators import bind_context, bind
from api.models import AssistThirdInfo, ActUserWechatInfo

@bind('activity/record/wechat_info')
def record_wechat_info(openid, nickname, imgurl, **kwargs):
    '''
    记录微信code对应的openid数据
    '''
    AssistThirdInfo.upsert(openid, nickname, imgurl)


@bind_context('activity/wechat/assist_bind')
def activity_wechat_bind(ctx, user_id, openid):
    '''
    通过openid与userid将用户与第三方信息绑定
    '''
    ActUserWechatInfo.create_bind_relation(user_id, openid, aty_type=TEMP_ACTIVITY_TYPE.NORMAL_ASSIST)
