# coding=utf-8
import os
import logging

LOG_DIR = '/data/log/gaia/app/'


logging.basicConfig(
    level=logging.INFO,
    format='%(asctime)s %(levelname)s %(module)s.%(funcName)s Line:%(lineno)d  %(message)s',
    filename=os.path.join(LOG_DIR, 'filelog.log'),
)

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,

    'filters': {
        'require_debug_true': {
            '()': 'django.utils.log.RequireDebugTrue',
        },
    },

    'formatters': {
        'verbose': {
            'format': '%(asctime)s %(levelname)s %(module)s.%(funcName)s Line:%(lineno)d  %(message)s'
        },
        'simple': {
            'format': '%(levelname)s %(message)s'
        },
        'profile': {
            'format': '%(asctime)s %(message)s'
        },
        'json': {
            '()': 'pythonjsonlogger.jsonlogger.JsonFormatter',
            'fmt': '%(message)s',
        },
        'raw': {
            'format': '%(message)s',
        },
        'normal': {
            'format': '[%(asctime)s]-[%(levelname)s]:[%(module)s.%(funcName)s] %(message)s'
        }
    },

    'handlers': {
        'null': {
            'level': 'DEBUG',
            'class': 'django.utils.log.NullHandler',
        },
        'console': {
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
            'formatter': 'simple'
        },

        # 默认的服务器Log(保存到log/filelog.log中, 通过linux的logrotate来处理日志的分割
        'default': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'filelog.log'),
            'formatter': 'verbose',
        },

        # 默认的服务器ERROR log
        'default_err': {
            'level': 'ERROR',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'error_logger.log'),
            'formatter': 'verbose',
        },
        'exception_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'exception_logger.log'),
            'formatter': 'raw',
        },
        'info_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'info_logger.log'),
            'formatter': 'verbose',
        },
        'ai_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'ai_logger.log'),
            'formatter': 'verbose',
        },
        'auth_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'auth_logger.log'),
            'formatter': 'verbose',
        },
        'profile_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'profile.log'),
            'formatter': 'profile',
        },
        'gaia_auth_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'gaia_auth_logger.log'),
            'formatter': 'verbose',
        },
        'push_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'push_logger.log'),
            'formatter': 'verbose',
        },
        'sql_logger': {
            'level': 'DEBUG',
            'filters': ['require_debug_true'],
            'class': 'logging.handlers.RotatingFileHandler',
            'maxBytes': 100000000,  # 100M
            'backupCount': 3,
            'filename': os.path.join(LOG_DIR, 'sql_logger.log'),
            'formatter': 'verbose',
        },
        'search_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'search_logger.log'),
            'formatter': 'verbose',
        },
        'sms_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'sms_logger.log'),
            'formatter': 'verbose',
        },
        'conversation_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'conversation_logger.log'),
            'formatter': 'verbose',
        },
        'push_block_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'push_block_logger.log'),
            'formatter': 'verbose',
        },
        'async_queue_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'async_queue_logger.log'),
            'formatter': 'verbose',
        },
        'async_task_handler': {
            'level': 'DEBUG',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'async_task.log'),
            'formatter': 'verbose',
        },
        'async_debug_handler': {
            'level': 'DEBUG',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'async_debug.log'),
            'formatter': 'verbose',
        },
        'period_task_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'period_task_logger.log'),
            'formatter': 'verbose',
        },
        'pay_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'pay_logger.log'),
            'formatter': 'verbose',

        },
        'wechat_pay_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'wechat_pay_logger.log'),
            'formatter': 'verbose',
        },
        'wechat_refund_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'wechat_refund_logger.log'),
            'formatter': 'verbose',
        },
        'alipay_refund_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'alipay_refund_logger.log'),
            'formatter': 'verbose',
        },
        'alipay_pay_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'alipay_pay_logger.log'),
            'formatter': 'verbose',
        },
        'repeat_refund_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'repeat_refund_logger.log'),
            'formatter': 'verbose',
        },
        'recommend_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'recommend_logger.log'),
            'formatter': 'verbose',
        },
        'apple_pay_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'apple_pay_logger.log'),
            'formatter': 'verbose',
        },
        'apple_refund_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'apple_refund_logger.log'),
            'formatter': 'verbose',
        },
        'device_record_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'device_record_logger.log'),
            'formatter': 'verbose',
        },
        'user_push_hdlr': {
            'level': 'INFO',
            'class': 'logging.FileHandler',
            'filename': os.path.join(LOG_DIR, 'user_push.log'),
            'formatter': 'json',
        },
        'doctor_push_hdlr': {
            'level': 'INFO',
            'class': 'logging.FileHandler',
            'filename': os.path.join(LOG_DIR, 'doctor_push.log'),
            'formatter': 'json',
        },
        'installment_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'installment_logger.log'),
            'formatter': 'verbose',
        },
        'installment_callback_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'installment_callback_logger.log'),
            'formatter': 'verbose',
        },
        'doctor_switch_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'doctor_switch_account.log'),
            'formatter': 'verbose',
        },
        'doctor_unread_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'doctor_unread.log'),
            'formatter': 'verbose',
        },
        'doctor_stats_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'doctor_stats.log'),
            'formatter': 'verbose',
        },
        'yinuo_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'yinuo_logger.log'),
            'formatter': 'verbose',
        },
        'qiniu_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'qiniu_logger.log'),
            'formatter': 'verbose',
        },
        'mars_call_hdlr': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'mars_call_logger.log'),
            'formatter': 'verbose',
        },
        'channel_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'channel_logger.log'),
            'formatter': 'verbose',
        },
        'locate_city_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'locate_city_logger.log'),
            'formatter': 'json',
        },
        'tracer_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'tracer.log'),
            'formatter': 'raw'
        },
        # 陌陌 打点日志
        "momo_stat_log_handler": {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'momo_stat_log.log'),
            'formatter': 'verbose',
        },
        "cache_skus_logger": {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'cache_skus_logger.log'),
            'formatter': 'verbose',
        },
        'user_handler': {
              'level': 'INFO',
              'class': 'logging.handlers.TimedRotatingFileHandler',
              'filename': os.path.join(LOG_DIR, 'user.log'),
              'formatter': 'normal',
              'when': 'midnight',
              'interval': 1,
              'backupCount': 30,
        },
        'goods_handler': {
              'level': 'INFO',
              'class': 'logging.handlers.TimedRotatingFileHandler',
              'filename': os.path.join(LOG_DIR, 'goods.log'),
              'formatter': 'normal',
              'when': 'midnight',
              'interval': 1,
              'backupCount': 30,
          },
        "user_transfer_log_handler": {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'user_transfer.log'),
            'formatter': 'normal',
        },
        'price_handler': {
              'level': 'INFO',
              'class': 'logging.handlers.TimedRotatingFileHandler',
              'filename': os.path.join(LOG_DIR, 'price.log'),
              'formatter': 'normal',
              'when': 'midnight',
              'interval': 1,
              'backupCount': 30,
        },
        'user_activity_handler': {
              'level': 'INFO',
              'class': 'logging.handlers.TimedRotatingFileHandler',
              'filename': os.path.join(LOG_DIR, 'user_activity.log'),
              'formatter': 'normal',
              'when': 'midnight',
              'interval': 1,
              'backupCount': 30,
        },
        'hera_feed_handler': {
              'level': 'INFO',
              'class': 'logging.handlers.TimedRotatingFileHandler',
              'filename': os.path.join(LOG_DIR, 'hera_feed.log'),
              'formatter': 'normal',
              'when': 'midnight',
              'interval': 1,
              'backupCount': 30,
        },
        'smart_rank_handler': {
              'level': 'INFO',
              'class': 'logging.handlers.TimedRotatingFileHandler',
              'filename': os.path.join(LOG_DIR, 'smart_rank.log'),
              'formatter': 'normal',
              'when': 'midnight',
              'interval': 1,
              'backupCount': 30,
        },
        'cache_handler': {
              'level': 'INFO',
              'class': 'logging.handlers.TimedRotatingFileHandler',
              'filename': os.path.join(LOG_DIR, 'cache.log'),
              'formatter': 'normal',
              'when': 'midnight',
              'interval': 1,
              'backupCount': 30,
        },

        'wechat_account_handler': {
              'level': 'INFO',
              'class': 'logging.handlers.RotatingFileHandler',
              'filename': os.path.join(LOG_DIR, 'wechat_account.log'),
              'formatter': 'normal',
              # 'when': 'midnight',
              # 'interval': 1,
              # 'backupCount': 30,
        },
        'order_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'order_logger.log'),
            'formatter': 'verbose',
        },
        'yibao_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'yibao_logger.log'),
            'formatter': 'verbose',
        },
    },

    'loggers': {
        'django': {
            'handlers': ['default'],
            'propagate': True,
            'level': 'INFO',
        },
        'gm_tracer.subscribe': {
            'handlers': ['tracer_handler'],
            'propagate': False,
            'level': 'INFO'
        },
        'django.request': {
            'handlers': ['default_err'],
            'level': 'ERROR',
            'propagate': False,
        },
        'django.db.backends': {
            'handlers': ['sql_logger'],
            'level': 'DEBUG',
        },
        'exception_logger': {
            'handlers': ['exception_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'info_logger': {
            'handlers': ['info_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'ai_logger': {
            'handlers': ['ai_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'auth_logger': {
            'handlers': ['auth_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'err_logger': {
            "handlers": ['default_err'],
            'level': "ERROR",
            "propagate": False,
        },
        'profile': {
            "handlers": ['profile_logger'],
            'level': "INFO",
            "propagate": False,
        },
        'gaia_auth_logger': {
            "handlers": ['gaia_auth_logger'],
            'level': "INFO",
            "propagate": False,
        },
        'push_logger': {
            'handlers': ['push_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'search_logger': {
            'handlers': ['search_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'sms_logger': {
            'handlers': ['sms_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'conversation_logger': {
            'handlers': ['conversation_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'push_block_logger': {
            'handlers': ['push_block_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'async_queue': {
            'handlers': ['async_queue_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'async_task': {
            'handlers': ['async_task_handler'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'async_debug': {
            'handlers': ['async_debug_handler'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'period_task_logger': {
            'handlers': ['period_task_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'pay_logger': {
            'handlers': ['pay_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'wechat_pay_logger': {
            'handlers': ['wechat_pay_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'wechat_refund_logger': {
            'handlers': ['wechat_refund_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'alipay_refund_logger': {
            'handlers': ['alipay_refund_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'alipay_pay_logger': {
            'handlers': ['alipay_pay_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'repeat_refund_logger': {
            'handlers': ['repeat_refund_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'recommend_logger': {
            'handlers': ['recommend_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'apple_pay_logger': {
            'handlers': ['apple_pay_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'apple_refund_logger': {
            'handlers': ['apple_refund_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'device_record_logger': {
            'handlers': ['device_record_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'user_push_logger': {
            'handlers': ['user_push_hdlr'],
            'level': 'INFO',
            'propagate': False,
        },
        'doctor_push_logger': {
            'handlers': ['doctor_push_hdlr'],
            'level': 'INFO',
            'propagate': False,
        },
        'installment_logger': {
            'handlers': ['installment_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'installment_callback_logger': {
            'handlers': ['installment_callback_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'doctor_switch_logger': {
            'handlers': ['doctor_switch_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'doctor_unread_logger': {
            'handlers': ['doctor_unread_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'doctor_stats_logger': {
            'handlers': ['doctor_stats_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'yinuo_logger': {
            'handlers': ['yinuo_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'qiniu_logger': {
            'handlers': ['qiniu_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'mars_call': {
            'handlers': ['mars_call_hdlr'],
            'level': 'INFO',
            'propagate': False,
        },
        'gm_serializer': {
            'handlers': ['console'],
            'propagate': False,
            'level': 'DEBUG'
        },
        'channel_logger': {
            'handlers': ['channel_handler'],
            'propagate': False,
            'level': 'INFO'
        },
        'locate_city_logger': {
            'handlers': ['locate_city_handler'],
            'propagate': False,
            'level': 'INFO'
        },
        'momo_stat_logger': {
            'handlers': ['momo_stat_log_handler'],
            'propagate': False,
            'level': 'INFO'
        },
        'cache_skus_logger': {
            'handlers': ['cache_skus_logger'],
            'propagate': False,
            'level': 'INFO'
        },
        'user_logger': {
             'handlers': ['user_handler'],
             'propagate': False,
             'level': 'INFO'
        },
        'goods_logger': {
             'handlers': ['goods_handler'],
             'propagate': False,
             'level': 'INFO'
        },
        'user_transfer_logger': {
            'handlers': ['user_transfer_log_handler'],
            'propagate': False,
            'level': 'INFO'
        },
        'price_logger': {
             'handlers': ['price_handler'],
             'propagate': False,
             'level': 'INFO'
        },
        'user_activity_logger': {
             'handlers': ['user_activity_handler'],
             'propagate': False,
             'level': 'INFO'
        },
        'hera_feed_logger': {
             'handlers': ['hera_feed_handler'],
             'propagate': False,
             'level': 'INFO'
        },
        'smart_rank_logger': {
             'handlers': ['smart_rank_handler'],
             'propagate': False,
             'level': 'INFO'
        },
        'cache_logger': {
             'handlers': ['cache_handler'],
             'propagate': False,
             'level': 'INFO'
        },

        'wechat_account_logger': {
            'handlers': ['wechat_account_handler'],
            'propagate': False,
            'level': 'INFO'
        },
        'order_logger': {
             'handlers': ['order_handler'],
             'propagate': False,
             'level': 'INFO'
        },
        'yibao_logger': {
             'handlers': ['yibao_handler'],
             'propagate': False,
             'level': 'INFO'
        },
    },
}
