# -*- coding: UTF-8 -*-
from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder
from gm_dataquery.db import DB

from talos.models.report import FilterWord
from . import TalosDataSQLQuery


class FilterWordDB(DataBuilder):
    pass


@DB
class FilterWordDQ(TalosDataSQLQuery):
    model = FilterWord
    data_model = FilterWordDB

    def filter_is_filter(self, srch_key, srch_val, regex=False):
        return Q(is_filter=srch_val)

    def filter_in_user_name(self, srch_key, srch_val, regex=False):
        return Q(in_user_name=srch_val)

    def filter_in_topic_content(self, srch_key, srch_val, regex=False):
        return Q(in_topic_content=srch_val)

    def filter_in_topic_reply(self, srch_key, srch_val, regex=False):
        return Q(in_topic_reply=srch_val)

    def filter_in_topic_chat(self, srch_key, srch_val, regex=False):
        return Q(in_topic_chat=srch_val)

    def filter_add_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

