# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

from django.db import models


class Tractate_Keyword(models.Model):
    class Meta:
        verbose_name = u'新百科tab'
        db_table = 'al_tractate_city_hotkeyword'
        unique_together = (("city_id", "rank"),)

    tractate_id = models.IntegerField(verbose_name=u'帖子ID')
    city_id = models.CharField(verbose_name=u'城市id', max_length=64)
    search_num = models.IntegerField(verbose_name=u"搜索次数")
    rank = models.IntegerField(verbose_name=u'排名')
    search_time = models.CharField(verbose_name=u"时间", max_length=20)


