class PostgresRouter(object):
    postgres_apps = ('search', 'postgre_user_tag')

    def db_for_read(self, model, **hints):
        """
        Attempts to read auth models go to auth_db.
        """
        if model._meta.app_label in self.postgres_apps:
            return 'postgres'
        return None

    def db_for_write(self, model, **hints):
        """
        Attempts to write auth models go to auth_db.
        """
        if model._meta.app_label in self.postgres_apps:
            return 'postgres'
        return None

    def allow_migrate(self, db, model):
        """
        Make sure the auth app only appears in the 'auth_db'
        database.
        """
        if db == 'postgres':
            return model._meta.app_label in self.postgres_apps
        elif model._meta.app_label in self.postgres_apps:
            return False
        return None


