def to_str(number):
    return str(number) if isinstance(number, (int, float, long)) else number


class ListDict:
    def __init__(self, l):
        if isinstance(l, list):
            self.l = l

    def to_list(self):
        result = []
        for i in self.l:
            result.extend(i.values())
        return result

    def to_dict(self):
        result = {}
        for i in self.l:
            for k, v in i.items():
                result[k] = v
        return result

    def to_str(self):
        return ','.join(self.to_list_str())

    def to_dict_str(self):
        result = {}
        for i in self.l:
            for k, v in i.items():
                result[k] = to_str(v)
        return result

    def to_list_str(self):
        return map(to_str, self.to_list())
