# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from .topic import Problem


class WechatMaterial(models.Model):
    class Meta:
        verbose_name = u'微信公众号文章'
        db_table = 'api_wechatmaterial'
        app_label = 'talos'
        unique_together = ('material_id', 'number')

    material_id = models.CharField(max_length=128, verbose_name=u'素材id')
    number = models.IntegerField(verbose_name=u'素材NUMBER')
    thumb_media_id = models.CharField(max_length=128, verbose_name=u'素材thumb id')
    thumb_url = models.CharField(max_length=256, verbose_name=u'图文消息的封面图片的地址，第三方开发者也可以使用这个URL下载图片到自己服务器中，然后显示在自己网站上')
    show_cover_pic = models.BooleanField(default=False, verbose_name=u"是否显示封面")
    author = models.CharField(max_length=128, verbose_name=u'作者')
    digest = models.CharField(max_length=128, verbose_name=u'摘要')
    content = models.TextField(verbose_name=u'图文消息的具体内容，支持HTML标签，必须少于2万字符，小于1M，且此处会去除JS')
    url = models.CharField(max_length=256, verbose_name=u'verbose_name图文页的URL，或者，当获取的列表是图片素材列表时，该字段是图片的URL')
    content_source_url = models.CharField(max_length=256, verbose_name=u'图文消息的原文地址，即点击“阅读原文”后的URL')
    update_time = models.DateTimeField(verbose_name=u'这篇图文消息素材的最后更新时间', auto_now_add=True)
    name = models.CharField(max_length=128, verbose_name=u'文件名称')
    title = models.CharField(max_length=256, verbose_name=u'文件名称')
    topic = models.ForeignKey(Problem, default=None, null=True, blank=True)
