# coding=utf-8

from django.core.management import BaseCommand
from hippo.models.merchant import Merchant, MerchantRelevance
from hippo.models.doctor import Doctor


class Command(BaseCommand):
    """
    初始化商户数据
    python manage.py add_merchant_data
    """

    def handle(self, *args, **options):
        doctors = Doctor.objects.filter(is_merchant=True)

        for doctor in doctors.iterator():
            merchant, _ = Merchant.objects.get_or_create(doctor_id=doctor.id, doctor_name=doctor.name)
            for item in doctor.get_merchant_doctors():
                mr, _ = MerchantRelevance.objects.get_or_create(merchant_id=merchant.id, doctor_id=item['doctor_id'])
                print item['doctor_id']

        print 'Done!'