# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from api.models import Doctor
from api.models import Hospital, HospitalInfo


class HospitalDB(DataBuilder):
    def getval_city(self, obj):
        return obj.city.name if obj.city else ''


@DB
class HospitalDQ(DataSQLQuery):
        model = Hospital
        data_model = HospitalDB


class HospitalInfoDB(DataBuilder):
    def getval_hospital_level_img(self, obj):
        return obj.base_info()['hospital_level']['images']

    def getval_hospital_area_img(self, obj):
        return obj.base_info()['hospital_area']['images']

    def getval_city_num_img(self, obj):
        return obj.base_info()['city_num']['images']

    def getval_hospital_num_img(self, obj):
        return obj.base_info()['hospital_num']['images']

    def getval_operation_num_img(self, obj):
        return obj.base_info()['operation_num']['images']

    def getval_injection_num_img(self, obj):
        return obj.base_info()['injection_num']['images']

    def getval_laser_num_img(self, obj):
        return obj.base_info()['laser_num']['images']


@DB
class HospitalInfoDQ(DataSQLQuery):
    model = HospitalInfo
    data_model = HospitalInfoDB

