# coding=utf-8
from django.db.models import Q
from datetime import datetime
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from api.models import WaterMark, WaterMarkService


@DB
class WaterMarkDQ(DataSQLQuery):
    model = WaterMark
    data_model = DataBuilder

    def filter_status(self, srch_key, srch_val, regex=False):
        now = datetime.now()
        q = Q()
        if '1' in srch_val:
            q |= Q(start_time__gt=now)
        if '2' in srch_val:
            q |= Q(start_time__lte=now) & Q(end_time__gte=now)
        if '3' in srch_val:
            q |= Q(end_time__lt=now)
        return q


@DB
class WaterMarkService(DataSQLQuery):
    model = WaterMarkService
    data_model = DataBuilder
