# -*- coding: UTF-8 -*-
from __future__ import absolute_import
from api.models.slide import ButtonGadget, ZoneLayout, CommunityDeploy
from rpc.decorators import bind_context
from gm_types.gaia import GADGET_PAGE_TYPE
from talos.tools.recommend_tool import RecommendZoneDeploy

uri_pre = 'hera/communityhome'
# TODO 这个地方要不要考虑作为通用接口挪到talos里面 不再以hera作为endpoint

@bind_context(uri_pre + '/set_button')
def set_button_layout(ctx, layout_info):
    ButtonGadget.set_buttons(
        page_type=GADGET_PAGE_TYPE.COMMUNITY_HOME,
        button_list=layout_info['button_list'],
        button_list_visible=layout_info['button_list_visible'])


@bind_context(uri_pre + '/get_button')
def get_button_layout(ctx):
    return ButtonGadget.get_buttons(page_type=GADGET_PAGE_TYPE.COMMUNITY_HOME)


@bind_context(uri_pre + '/set_zonelayout')
def set_zone_layout(ctx, zonelayout_info):
    ZoneLayout.set_zone_layout(
        zone_visible=zonelayout_info.get('zone_visible', True),
        hot_in_24hours=zonelayout_info.get('hot_in_24hours'))


@bind_context(uri_pre + '/get_zonelayout')
def get_zone_layout(ctx):
    return ZoneLayout.get_zone_layout()


@bind_context(uri_pre + '/get_deploy')
def get_button_layout(ctx):
    return CommunityDeploy.get_community_deploy()


@bind_context(uri_pre + '/set_deploy')
def set_button_layout(ctx, deploy_info):
    CommunityDeploy.set_community_deploy(deploy_info=deploy_info)


@bind_context(uri_pre + '/get_recommend_zone')
def get_recommend_zone(ctx):
    return RecommendZoneDeploy.get()


@bind_context(uri_pre + '/set_recommend_zone')
def set_recommend_zone(ctx, deploy_info):
    return RecommendZoneDeploy.set(deploy_info)
