from __future__ import unicode_literals, absolute_import
import json
from django.core.management.base import NoArgsCommand
from gm_types.plutus.insurance import INSURANCE_TYPE
from gm_types.plutus.insurance import INSURANCE_STATUS

from pay.models import YinuoOrder
from rpc.tool.time_tool import format_time


class Command(NoArgsCommand):
    def handle(self, *args, **options):
        f = open('/tmp/yinuo.txt', 'w')
        for yinuo in YinuoOrder.objects.filter(credential_id__isnull=False):
            status = INSURANCE_STATUS.ACTIVATED
            dic = dict(
                order_id=yinuo.order_id,
                created_at=yinuo.info['created_at'],
                insurance_type=INSURANCE_TYPE.YINUO,
                premium=yinuo.premium,
                policy_no=yinuo.credential_id,
                sum_insured=50000,
                policy_begin_date=yinuo.info['begin_date'],
                policy_end_date=yinuo.info['end_date'],
                operation_time=format_time(yinuo.order.validate_time),
                confirmed_at=yinuo.info['created_at'],
                status=status,
            )
            f.write(json.dumps(dic))
            print dic
            f.write('\n')