# coding=utf-8

from django.core.management.base import BaseCommand
from gm_types.trade import STATEMENT_STATUS
from pay.models import Statement, StatementAccount


class Command(BaseCommand):
    """
    python manage.py init_170301_statement_account
    """
    def handle(self, *args, **options):
        statements = Statement.objects.filter(status__in=[STATEMENT_STATUS.CHECKED, STATEMENT_STATUS.SETTLED])
        for statement in statements:
            try:
                account = statement.doctor.merchant.account
                StatementAccount.objects.create(
                    statement=statement,
                    province=account.province,
                    city=account.city,
                    bank=account.bank,
                    account_name=account.account_name,
                    account_number=account.account_number,
                    account_type=account.account_type,
                )
                print statement.id
            except Exception as e:
                print statement.id, e.message