#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   17/12/02 14:50:09
#   Desc    :   美分商城
#

from __future__ import unicode_literals, absolute_import

from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.point import GOODS_TYPE, ACTIVITY_TYPE
from gm_types.gaia import RECEVEIVINGEND

from django.db.models import Model
from django.db.models import BooleanField, ForeignKey, OneToOneField
from django.db.models import CharField, DateTimeField, IntegerField, TextField

from api.models import Special


class PointGoods(Model):
    class Meta:
        verbose_name = '美分商城礼品'

    name = CharField(u'礼品名称', max_length=50)
    describe = CharField(u'礼品介绍', max_length=100)
    thumb = ImgUrlField(u'小图', img_type=IMG_TYPE.NOWATERMARK, max_length=100)
    image = ImgUrlField(u'大图', img_type=IMG_TYPE.NOWATERMARK, max_length=100)
    goods_type = CharField(u'礼品类型', choices=GOODS_TYPE, max_length=10)
    comment = CharField(u'温馨提示', max_length=200)
    channel_gift_id = IntegerField(u'美券', default=0)
    point = IntegerField(u'美分', default=0)
    create_time = DateTimeField(auto_now_add=True)


class PointActivity(Model):
    class Meta:
        verbose_name = '活动（抽奖+兑换）'

    name = CharField(u'标题', max_length=50)
    describe = CharField(u'礼品介绍', max_length=100)
    start_time = DateTimeField(u'开始时间', auto_now_add=True)
    end_time = DateTimeField(u'结束时间')
    is_online = BooleanField(default=False)
    cost = IntegerField(u'抽奖所需美分', default=0)
    activity_type = CharField(u'类型', choices=ACTIVITY_TYPE, max_length=10)
    frequent_limit = IntegerField(u'抽奖单用户日限制', default=0)
    placeholder = IntegerField(u'活动需要占位礼品数', default=0)
    create_time = DateTimeField(auto_now_add=True)


class PointActivityGoods(Model):
    class Meta:
        verbose_name = u'活动礼品关联'

    stock = IntegerField(u'总库存', default=0)
    current_stock = IntegerField(u'当前库存', default=0)
    order = IntegerField(u'顺序', default=0)
    point = IntegerField(u'需要花费美分', default=0)
    level_limit = IntegerField(u'用户等级限制', default=0)
    good = ForeignKey(PointGoods, related_name='activities')
    activity = ForeignKey(PointActivity, related_name='goods')
    is_online = BooleanField(default=True)
    weight = IntegerField(u'权重', default=0)
    limit = IntegerField(u'单用户活动周期内领取上限', default=0)
    base_count = IntegerField(u'活动关联礼品的已兑换基数', default=0)
    create_time = DateTimeField(auto_now_add=True)


class PointUserGoods(Model):
    class Meta:
        verbose_name = u'用户获取礼品记录'

    user_id = IntegerField(u'用户')
    point = IntegerField(u'花费积分')
    user_level = IntegerField(u'获取时等级')
    express_no = CharField(u'快递号', max_length=100)
    activity_goods = ForeignKey(PointActivityGoods, related_name='exchanges', null=True)
    activity = ForeignKey(PointActivity, related_name='exchanges')
    create_time = DateTimeField(auto_now_add=True)
    special = ForeignKey(Special, verbose_name=u'关联专题', null=True)


class PointSnapshot(Model):
    class Meta:
        verbose_name = u'兑换快照'

    user_goods = OneToOneField(PointUserGoods)
    user_exchange = TextField(u'用户兑换快照')
    goods = TextField(u'礼品快照')
    activity = TextField(u'活动快照')
    activity_goods = TextField(u'活动礼品关联快照')
    extra = TextField(u'用户相关信息')
