#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   18/04/02 19:18:31
#   Desc    :   dataquery
#

from datetime import date, timedelta

from django.db.models import Q

from gm_dataquery.dataquery import DataSQLQuery, DataBuilder
from gm_dataquery.db import DB
from gm_dataquery.client import Model

from statistic.models import StatisticServiceSmartRankV3


class StatisticServiceSmartRankV3DB(DataBuilder):

    def getval_consult_value(self, item):
        return item.get_consult_value()

    def getval_ctr_value(self, item):
        return item.get_ctr_value()

    def getval_discount_value(self, item):
        return item.get_discount_value()

    def getval_cpt_value(self, item):
        return item.get_cpt_value()

    def getval_cpc_price(self, item):
        return item.get_cpc_price()


@DB
class StatisticServiceSmartRankV3DQ(DataSQLQuery):
    model = StatisticServiceSmartRankV3
    data_model = StatisticServiceSmartRankV3DB

    def filter_today(self, field, value, regex=False):
        if value:
            return Q(stat_date=date.today() - timedelta(days=1))
        return Q()
