# coding=utf-8
from __future__ import print_function, unicode_literals, absolute_import
import re
from django.core.management.base import BaseCommand
from gm_types.gaia import TOPIC_TYPE

from answer.models import Question, Answer, QuestionImage, AnswerImage
from answer.models import QuestionTag, AnswerReply
from api.models import Problem, Tag


class Command(BaseCommand):
    def handle(self, *args, **kwargs):
        num = 100
        all_problem = Problem.objects.filter(is_online=True, topic_type__in=[TOPIC_TYPE.ASK, TOPIC_TYPE.TOPIC])
        problems, index = all_problem[0:num], 0
        while problems:
            for problem in problems:
                self.convert_question_topic(problem)
            index += 1
            problems = all_problem[index * num: (index + 1) * num]

    def convert_question_topic(self, problem):
        try:
            problem.stream
            return
        except:
            pass
        try:
            content = problem.ask + problem.answer
            title = re.split("\?|？", content)[0]
            q = Question.objects.create(user_id=problem.user_id, problem_id=problem.id,
                                        title=title[0:100], content=content,
                                        create_time=problem.created_time, update_time=problem.created_time)

            for tag in problem.tags.all():
                try:
                    tag = Tag.objects.get(id=tag.id)
                    QuestionTag(question=q, tag=tag).save()
                except Tag.DoesNotExist:
                    pass

            for image in problem.images.all():
                QuestionImage.objects.create(question=q, image_url=image.image_url)
            print('finish problem id: ' + str(problem.id))
            self.convert_answer_topic_reply(question=q, problem=problem)

        except Exception as e:
            print(e)
            print('error: problem id: ' + str(problem.id))

    def convert_answer_topic_reply(self, question, problem):
        replys = problem.topicreply_set.filter(is_online=True, commented_reply__isnull=True)
        for reply in replys:
            try:
                answer = Answer.objects.create(user_id=reply.user_id,
                                               topicreply_id=reply.id,
                                               question=question,
                                               content=reply.content,
                                               like_num=reply.like_num,
                                               create_time=reply.reply_date,
                                               update_time=reply.reply_date)
                for image in reply.images.all():
                    AnswerImage.objects.create(image_url=image.image_url, answer=answer)

                print('finish reply id: ' + str(reply.id))

                self.convert_answer_reply_topic_reply(answer, reply)
            except Exception as e:
                print(e)
                print('error: reply id: ' + reply.id)

    def convert_answer_reply_topic_reply(self, answer, topicreply):
        topicreplys = topicreply.comments.all()
        for reply in topicreplys:
            try:
                answer_reply = AnswerReply.objects.create(content=reply.content,
                                                          user_id=reply.user_id,
                                                          answer=answer,
                                                          create_time=reply.reply_date,
                                                          update_time=reply.reply_date,
                                                          topicreply_id=reply.id,
                                                          like_num=reply.like_num)
                print('finish reply id: ' + str(reply.id))

            except Exception as e:
                print(e)
                print('error: reply id ' + reply.id)
