# coding=utf-8

from django.db import models


class AlipayAccoutMaintenance(models.Model):
    """
    支付宝账户维护表
    """
    class Meta:
        verbose_name = u'支付宝账户'
        db_table = 'api_alipayaccout'
        app_label = 'api'
    account = models.CharField(max_length=128, null=False, verbose_name=u'支付宝账户', unique=True)
    name = models.CharField(max_length=128, null=False, verbose_name=u'用户名')
    created_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'最后更新时间', auto_now=True)
