# coding=utf-8
import json

from rpc.cache import service_template_images


class ServiceTemplateImages(object):
    """
    美购编辑图片模板缓存
    """
    key = 'service_template_images'

    @classmethod
    def get(cls):
        try:
            image_cache = service_template_images.get(cls.key)
            images = json.loads(image_cache)
            return images
        except:
            return []

    @classmethod
    def set(cls, images):
        if not images:
            return
        service_template_images.set(cls.key, json.dumps(images))

    @classmethod
    def append(cls, image):
        if not image:
            return

        images = cls.get()
        images.append(image)
        cls.set(images)
