-- Deploy gaia:api_2015_11_05_create_table_api_serviceregister to mysql

BEGIN;

	CREATE TABLE `api_serviceregister` (
	    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	    `name` varchar(100) NOT NULL,
	    `comment` varchar(200) NULL,
	    `reservation` integer NOT NULL,
	    `refund_anytime` bool NOT NULL,
	    `is_stage` bool NOT NULL,
	    `compensation_in_advance` bool NOT NULL,
	    `show_location` bool NOT NULL,
	    `share_get_cashback` bool NOT NULL,
	    `created_time` datetime(6) NULL,
	    `start_time` datetime(6) NULL,
	    `end_time` datetime(6) NULL,
	    `delay` varchar(20) NULL,
	    `total_num` integer NULL,
	    `single_user_buy_limit` integer NOT NULL,
	    `valid_duration` integer NULL,
	    `fake_sold_num` integer NOT NULL,
	    `extra_charge` varchar(200) NULL,
	    `soyoung_url` varchar(256) NOT NULL,
	    `yuemei_url` varchar(256) NOT NULL,
	    `status` varchar(20) NOT NULL,
	    `reason` varchar(200) NULL,
	    `reason1` varchar(200) NULL,
	    `reason2` varchar(200) NULL,
	    `approver_id` integer NULL,
	    `doctor_id` varchar(100) NULL,
	    `service_id` integer NULL,
	    `user_id` integer NOT NULL
	);
	CREATE TABLE `api_serviceregisterattr` (
	    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	    `name` varchar(40) NOT NULL,
	    `checked` bool NOT NULL,
	    `service_register_id` integer NULL
	);
	CREATE TABLE `api_serviceregisterattroption` (
	    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	    `name` varchar(40) NOT NULL,
	    `checked` bool NOT NULL,
	    `service_register_attr_id` integer NOT NULL
	);
	CREATE TABLE `api_serviceregisteritem` (
	    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
	    `key` varchar(40) NOT NULL,
	    `discount` integer NOT NULL,
	    `pre_payment_price` integer NOT NULL,
	    `original_price` integer NOT NULL,
	    `gengmei_price` integer NOT NULL,
	    `cash_back_rate` integer NOT NULL,
	    `cash_back_fee` integer NOT NULL,
	    `seckill_price` integer NOT NULL,
	    `is_online` bool NOT NULL,
	    `points_deduction_percent` integer NOT NULL,
	    `service_register_id` integer NOT NULL
	);

	ALTER TABLE `api_serviceregister` ADD CONSTRAINT `api_serviceregister_approver_id_4cbf9428a9344533_fk_auth_user_id` FOREIGN KEY (`approver_id`) REFERENCES `auth_user` (`id`);
	ALTER TABLE `api_serviceregister` ADD CONSTRAINT `api_serviceregister_doctor_id_142b1e0ef699f8f_fk_api_doctor_id` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
	ALTER TABLE `api_serviceregister` ADD CONSTRAINT `api_serviceregiste_service_id_7dc567316a231354_fk_api_service_id` FOREIGN KEY (`service_id`) REFERENCES `api_service` (`id`);
	ALTER TABLE `api_serviceregister` ADD CONSTRAINT `api_serviceregister_user_id_4b41d0913daa1215_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
	ALTER TABLE `api_serviceregisterattr` ADD CONSTRAINT `a_service_register_id_6fbe6390721f22c8_fk_api_serviceregister_id` FOREIGN KEY (`service_register_id`) REFERENCES `api_serviceregister` (`id`);
	ALTER TABLE `api_serviceregisterattroption` ADD CONSTRAINT `D1bce6825fb4afb7492d5c0919257e21` FOREIGN KEY (`service_register_attr_id`) REFERENCES `api_serviceregisterattr` (`id`);ALTER TABLE `api_serviceregisteritem` ADD CONSTRAINT `a_service_register_id_4cb49a86ee84120c_fk_api_serviceregister_id` FOREIGN KEY (`service_register_id`) REFERENCES `api_serviceregister` (`id`);

COMMIT;
