# -*- coding:utf-8 -*-

from django.core.management import BaseCommand

from api.models.face import FacialFeatureFamily
from api.models.face.heidong_scan import HeiDongDimensionDetail

from gm_types.gaia import (
    FACIAL_FEATUREA,
    CONTOUR_TYPE,
    CHIN_TYPE,
    EYEBROW_TYPE,
    EYE_TYPE,
    NOSE_TYPE,
    LIP_TYPE,
    TONGJU_BIYI_BIZHI,
    SHUANG_C_XIAN_JIAODU,
    RENZHONG_ZUICHUN_KEDI_BIZHI,
    ZHONGXIATING,
    SANYAN_BILI,
    NIEBU_QUANKUAN_XIAHE_XIABA_BIZHI,
    NIEBU_QUANKUAN_BIZHI,
    SHUANGYANPI_TYPE,
    YANDAI_TYPE,
    FALINGWEN_TYPE,
)

FACIAL_FEATUREA_TYPES = {
    FACIAL_FEATUREA.CONTOUR: CONTOUR_TYPE,
    FACIAL_FEATUREA.CHIN: CHIN_TYPE,
    FACIAL_FEATUREA.EYEBROW: EYEBROW_TYPE,
    FACIAL_FEATUREA.EYE: EYE_TYPE,
    FACIAL_FEATUREA.NOSE: NOSE_TYPE,
    FACIAL_FEATUREA.LIP: LIP_TYPE,
    FACIAL_FEATUREA.TONGJU_BIYI_BIZHI: TONGJU_BIYI_BIZHI,
    FACIAL_FEATUREA.SHUANG_C_XIAN_JIAODU: SHUANG_C_XIAN_JIAODU,
    FACIAL_FEATUREA.RENZHONG_ZUICHUN_KEDI_BIZHI: RENZHONG_ZUICHUN_KEDI_BIZHI,
    FACIAL_FEATUREA.ZHONGXIATING: ZHONGXIATING,
    FACIAL_FEATUREA.SANYAN_BILI: SANYAN_BILI,
    FACIAL_FEATUREA.NIEBU_QUANKUAN_XIAHE_XIABA_BIZHI: NIEBU_QUANKUAN_XIAHE_XIABA_BIZHI,
    FACIAL_FEATUREA.NIEBU_QUANKUAN_BIZHI: NIEBU_QUANKUAN_BIZHI,
    FACIAL_FEATUREA.SHUANGYANPI_TYPE: SHUANGYANPI_TYPE,
    FACIAL_FEATUREA.YANDAI_TYPE: YANDAI_TYPE,
    FACIAL_FEATUREA.FALINGWEN_TYPE: FALINGWEN_TYPE,
}


class Command(BaseCommand):
    """
    short_description，AttrOptions--name
    """

    def handle(self, *args, **kwargs):
        print('开始处理......')
        print("导出所有二级维度,数据量不大，分行写入，有错误的数据直接抛弃")
        heidong_data = HeiDongDimensionDetail.objects.all()
        cnt = 0
        for item in heidong_data:
            try:
                classification = self.get_chinese_from_enum(item.facial_type, item.classification)
                FacialFeatureFamily.objects.create(
                    classification=classification,
                    facial_type=item.facial_type,
                    desc1=item.analysis,
                    desc2='',
                    img_url='',
                    polymer_id=item.polymer_id,
                    is_online=False,
                    choice_button_words=item.choice_button_words,
                    service_button_words=item.service_button_words,
                    xcx=True,
                    client=True,
                    created_time=item.created_time,
                    updated_time=item.updated_time,
                )
            except Exception as e:
                print('复制{}条配置项时，出错误。错误栈信息{}'.format(item.id, e))
            cnt = cnt + 1
            print("完成{}条数据".format(cnt))
        print('处理完毕!')

    def get_chinese_from_enum(self, facial_type, classifcation):
        return FACIAL_FEATUREA_TYPES.get(facial_type, '').getDesc(classifcation, '')
