#! /usr/bin/env python
# -*- coding: utf-8 -*-

from django.db import models


class FaceChange(models.Model):
    class Meta:
        verbose_name = u'变脸拼图发起'
        db_table = 'api_face_app'

    user_id = models.IntegerField(verbose_name=u"用户id", db_index=True)
    photo_url = models.CharField(verbose_name=u"原始照片地址", max_length=128)
    yong_photo = models.CharField(verbose_name=u"变年轻照片地址", max_length=128, blank=True, default='')
    old_photo = models.CharField(verbose_name=u"变老照片地址", max_length=128, blank=True, default='')
    laugh_photo = models.CharField(verbose_name=u"微笑照片地址", max_length=128, blank=True, default='')
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    # pos_info = models.CharField(verbose_name=u"图片位置信息", max_length=50, blank=True, default=True)
    # puzzle = models.BooleanField(verbose_name=u"是否参与拼图", default=False)
    # puzzle_type = models.SmallIntegerField(verbose_name=u"拼图类型", default=0)
    # updated_time = models.DateTimeField(u'更新时间', auto_now=True)


class FacePuzzleShare(models.Model):
    class Meta:
        verbose_name = u'用户分享半张拼图'
        db_table = 'api_face_puzzle_half_share'

    sharer_face = models.ForeignKey(FaceChange)
    sharer_id = models.IntegerField(db_index=True)
    place = models.IntegerField(verbose_name="拼图分享人所在位置")
    sharer_name = models.CharField(verbose_name=u"分享者微信昵称", max_length=64, blank=True, default='')
    puzzle_type = models.SmallIntegerField(verbose_name=u"拼图类型", default=0)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)


class FacePuzzle(models.Model):
    class Meta:
        verbose_name = u"完成的变脸拼图"
        db_table = "api_face_together"

    puzzle_share_id = models.IntegerField(null=True)  # 可以没有
    sharer_face = models.ForeignKey(FaceChange, related_name='sharer_face')
    participant_face = models.ForeignKey(FaceChange, related_name='participant_face')
    participant_name = models.CharField(verbose_name=u"拼图者微信昵称", max_length=64, blank=True, default='')
    # todo: 参与者信息是否放到FaceChange表里面更恰当？
    # participant = models.IntegerField(verbose_name=u"参与者id")
    # participant_photo_url = models.CharField(verbose_name=u"参与者照片原图", max_length=50)
    puzzle_type = models.SmallIntegerField(verbose_name=u"拼图类型")
    puzzle_url = models.CharField(verbose_name=u"完成的拼图地址", max_length=128)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)


class PuzzleImage(models.Model):
    class Meta:
        verbose_name = u"时光机拼图"
        db_table = "api_puzzle_image"

    user_id = models.IntegerField(default=0)  # 未登录用户为0
    img_url_1 = models.CharField(verbose_name=u"照片地址1", max_length=128)
    img_url_2 = models.CharField(verbose_name=u"照片地址2", max_length=128)
    change_type = models.SmallIntegerField(verbose_name=u"拼图类型", default=1)
    generate_url = models.CharField(verbose_name=u"生成的图片", max_length=128)
    background_id = models.IntegerField(verbose_name=u"背景图id", default=1)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
