# coding=utf-8

"""用户三方账号信息"""

from gm_types.error import ERROR as ERROR_CODES
from gm_types.gaia import LOGIN_AUTH_TYPE

from rpc.decorators import bind_context
from rpc.tool.error_code import gen
from rpc.tool.log_tool import user_logger

from api.tool.user_tool import get_user_from_context
from api.models.freerecruitment import ThirdAccountInfo


@bind_context('api/freerecruitment/third_account')
def freerecruitment_third_account(ctx, push_type, activity_id, form_id, nick_name, img_url):
    """添加用户微信相关信息"""

    user = get_user_from_context(ctx)
    if not user:
        gen(ERROR_CODES.LOGIN_REQUIRED)

    try:
        activity = FreeRecruitment.objects.get(pk=activity_id)
    except FreeRecruitment.DoesNotExist:
        gen()

    if not activity.is_online:
        gen()

    ThirdAccountInfo.upsert(
        push_type=push_type,
        activity_id=activity_id,
        user_id=user.id,
        form_id=form_id,
        nick_name=nick_name,
        img_url=img_url
    )

    return
