# coding=utf-8

import json
import tablib
import xlrd
from datetime import datetime

from django.core.management import BaseCommand
from django.db.models import Q
from api.models import Service, ServiceItem
from rpc.tool.queryset_tool import big_qs_iter
from .utils import get_mail


lexicon = [
    u'更美', u'hot', u'HOT', u'top', u'TOP', u'最', u'第一', u'唯一', u'NO.1',
    u'独一无二', u'一流', u'一天', u'仅此一次', u'最后一波', u'国家级', u'全球级',
    u'宇宙级', u'世界级', u'顶级', u'顶尖', u'尖端', u'高级', u'极品', u'极佳', u'绝佳',
    u'绝对', u'终极',u'极致',u'首个',u'首选',u'独家',u'首发',u'首家',u'首次',u'首款',
    u'全国销量冠军',u'国家',u'填补国内空白',u'国际品质',u'大牌',u'金牌',u'名牌',u'王牌',u'领袖品牌',
    u'领先', u'领导者', u'缔造者', u'创领品牌', u'巨星', u'著名', u'掌门人', u'至尊', u'巅峰',
    u'奢侈', u'优秀', u'资深', u'领袖', u'之王', u'王者', u'冠军',  u'史无前例',u'前无古人',
    u'永久',u'万能',u'祖传',u'特效',u'无敌',u'纯天然',u'100%',u'高档',u'正品',u'真皮',u'超赚',
    u'精确',u'老字号',u'中国驰名商标',u'特供',u'专供',u'专家推荐', u'质量免检',u'免抽检',
    u'人气',u'爆款',u'热销',u'知名',u'名气',u'热卖',u'更美最佳',u'更美口碑',u'名医',u'无恢复期',
    u'预约', u'北京',
]

def need_export(name):
    for i in lexicon:
        if i in name:
            return True
    return False


class Command(BaseCommand):
    """
    python manage.py dump_20190403_export_all_spu_and_sku_names
    """

    def handle(self, *args, **options):
        dt_result_spu = tablib.Dataset()
        dt_result_spu.headers = [
            u'美购ID', u'美购名称', u'美购描述',
        ]
        dt_result_sku = tablib.Dataset()
        dt_result_sku.headers = [
            u'美购ID', u'美购名称', u'SKUID', u'SKU名称',
        ]
        now = datetime.now()
        services = Service.objects.using('slave').filter(is_online=True, start_time__lt=now).filter(Q(end_time__isnull=True) | Q(end_time__gt=now))
        for service in big_qs_iter(services):
            print(service.id, service.name)
            skus = service.items.filter(is_delete=False)
            if not skus.exists():
                continue

            service_id = service.id
            service_name = service.name
            short_description = service.short_description
            try:
                if need_export(short_description):
                    x = (
                        service_id,
                        service_name,
                        short_description,
                    )
                    dt_result_spu.append(x)
            except:
                print('error spu_id:', service_id)
            for sku in skus:
                try:
                    sku_name = sku.items_name[0]
                    if need_export(sku_name):
                        x = (
                            service_id,
                            service_name,
                            sku.id,
                            sku_name,
                        )
                        dt_result_sku.append(x)
                except:
                    print('error sku_id:', sku.id)

        get_mail(u'spu名称信息.xlsx', u'spu名称信息', u'zoumingzhe@igengmei.com', dt_result_spu.xlsx).send()
        get_mail(u'sku名称信息.xlsx', u'sku名称信息', u'zoumingzhe@igengmei.com', dt_result_sku.xlsx).send()
        print 'DONE!'