#!/usr/bin/env python
# -*- coding:utf-8 -*-

import time

from django.core.management import BaseCommand

from gm_types.gaia import VIDEO_CODE_STATUS

from wiki.models.video import VideoLibrary
from wiki.tasks.video_tasks import set_video_library_clipping_to_video


class Command(BaseCommand):
    """
    为百科视频库的视频添加webP动图
    """

    def handle(self, *args, **options):
        print('------ starting -----')
        start_time = time.time()
        print("start at: ", start_time)

        video_id_list = list(VideoLibrary.objects.filter(
            persistent_clip_status=VIDEO_CODE_STATUS.NOSTART
        ).values_list("id", flat=True))

        for video_id in video_id_list:
            set_video_library_clipping_to_video(video_id)

        end_time = time.time()
        print("end at: ", end_time)
        print('total use {} s.'.format(end_time - start_time))
        print('Done!')
