# -*- coding: UTF-8 -*-

import uuid

from django.db import models

# Enumeration is deprecated, reference: http://git.gengmei.cc/backend/gm-types
#from rpc.tool.enumeration import Enumeration
from gm_types.gaia import SETTLE_STATUS
from api.models import Doctor


class FinanceSettlement(models.Model):
    class Meta:
        verbose_name = u'财务结算'
        app_label = 'finance'

    id = models.UUIDField(primary_key=True, default=uuid.uuid1)
    settle_date = models.DateField(u'结算周期', null=True)
    created_at = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_at = models.DateTimeField(u'最后更新时间', auto_now=True)
    amount = models.IntegerField(u'结算金额', default=0)


class MechantSettlement(models.Model):
    class Meta:
        verbose_name = u'商户结算'
        app_label = 'finance'

    id = models.UUIDField(primary_key=True, default=uuid.uuid1)
    settle_id = models.CharField(u'对账单号', max_length=50)
    doctor = models.ForeignKey(Doctor)
    amount = models.IntegerField(u'结算金额', default=0)
    is_black = models.BooleanField(u'是否黑名单', default=False)
    status = models.IntegerField(u'结算状态', choices=SETTLE_STATUS, default=SETTLE_STATUS.UNSETTLE)
