# coding=utf-8

from django.core.management.base import BaseCommand

from api.models import Doctor
from pay.tasks.statement_task import create_one_statement
from pay.tool.time_tool import DatetimeTool


class Command(BaseCommand):
    def handle(self, *args, **options):
        dt = DatetimeTool()
        last_month_dt = dt.get_first_day_month(d_months=-1)
        doctor = Doctor.objects.get(pk='yrh')
        create_one_statement(doctor, last_month_dt)