# -*- coding:utf-8 -*-
from datetime import timedelta
from celery.schedules import crontab

zhengxing_db = 'zhengxing_test'

KEFU_PERSION_ID = 'a3c1087a1bdd11e682b70242c0a8020b'

QUESTION_SCORE_WEIGHT = {
    'time_score_weight': 1,  #
    'answers_num_score_weight': 1,
    'answer_views_score_weight': 1,
    'answer_likes_score_weight': 1,
    'question_view_score_weight': 1,
    'question_answer_likes_score_weight': 1,
}

ALLOWED_HOSEPT_BLACK_LIST = [
    '00000000-0000-0000-0000-000000000000',
]

# LIVE_REDIS = {'host': 'test-redis', 'port': 6379, 'db': 4}
LIVE_REDIS = {'host': '127.0.0.1', 'port': 6379, 'db': 4}

SECRET_KEY = 'fl-lv3j^czg(dupo@hbs(+_+djby9zelwt&rh71@b1x*ptmj4#(^'  # dev
BAIDUSHOUZHU_SALT = 'M2xiLklToiqtpWUij3hGfIFZystyKurJ'
DEBUG = True
TEMPLATE_DEBUG = True
RAVEN_CONFIG = {
    'dsn': 'http://c5b4ede52bc6452182565b529735a090:0324e8fff118445a9b38576213b8e759@sentry.igengmei.com/120',
}
SITE_ID = 1
USE_DOC = False
TEMPLATES = []
GIFT_LOWER_LIMIT = 10000
GAME_WISHTREE_COUPON_ID = 1196
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': "zhengxing_test",
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': 'bj-cdb-6slgqwlc.sql.tencentcdb.com',
        'PORT': '62120',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        }
    },
    'mimas': {
        'ENGINE': 'django.db.backends.mysql',  # 设置为mysql数据库
        'NAME': "mimas_test",
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': 'bj-cdb-6slgqwlc.sql.tencentcdb.com',
        'PORT': '62120',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",  # 为了支持emoji表情
        }
    }
}
SLAVE_DB_NAME = 'slave'
HERA_READ_DB = 'slave'
MIMAS_SLAVE_DB_NAME = 'mimas'

# ====================================================================================================
# =====================================GAIA_AUTHENTICATION============================================
# ====================================================================================================
GAIA_AUTHENTICATION = {
    'CHECK_MODE': 'PERMISSIVE',
    'SERVER_KEYS': [
        'basic:334+LrHY+Wh4IREkC4xjQcJ6fpIwlsH6HR8MKFVEH5LiyvqYq4QocqoNS7lcx23RO4v2FcB6YYoxMoEJhYoYpQ==',
        # pengfei, for ship
        'basic:c3AUKzE4iaGc5SBtkm3zMbjepw+vn7VHr/5fXaupEAo/HBeeVk6w+4EWEubwF1K9j6KSckd17hpBpQkNr9+uoA==',
        # chuncheng, for op_back
        'basic:M21gQkp0vWmDxlB5wVsIGCgbjdcshCsYaTgl4Rq0E6ug6Ma2teM9tpGCf5TZHsCGGC4cGQ4as9N3KmrDPQ43gA==',
        # pengfei, for wanmei_backend
        'basic:ZXhlV5AFrx7jy7vfwCFiANBlJyVK2kHfiZDVkeKlRkxjOlUb1euhRCbazG2aPdHkMNn8a+D/vqdZSYCj9qhpig==',
        # pengfei, for flag-ship
    ],
}

# ====================================================================================================
# ============================================REDIS===================================================
# ====================================================================================================
# BROKER_URL = 'redis://test-redis:6379/13'
BROKER_URL = 'redis://127.0.0.1:6379/13'
REDIS_URL = 'redis://redis.paas-test.env:6379/0'
DORIS_URL = 'redis://redis.paas-test.env:6379/2'
BROKER_TRANSPORT_OPTIONS = {'visibility_timeout': 60 * 60 * 24 * 3}  # 3days. Make sure that colleagues have knew that
REDIS = {
    'doctor': {'host': '127.0.0.1', 'port': 6379, 'db': 0},
    'hospital': {'host': '127.0.0.1', 'port': 6379, 'db': 1},
    'view': {'host': '127.0.0.1', 'port': 6379, 'db': 2},
    'user_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 5},
    'conversation_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 6},
    'tag_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 12},
    'diary': {'host': '127.0.0.1', 'port': 6379, 'db': 4},
    'page_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 15},
    'coupon_gift': {'host': '127.0.0.1', 'port': 6379, 'db': 10},
    'social_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 11},
    'vote_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 11},
    'wechat': {'host': '127.0.0.1', 'port': 6379, 'db': 11},
    'game': {'host': '127.0.0.1', 'port': 6379, 'db': 4},
    'resys_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 3},
    'user_reg_lock': {'host': '127.0.0.1', 'port': 6379, 'db': 3},
    'black_name': {'host': '127.0.0.1', 'port': 6379, 'db': 3},
    'sku_stock_lock': {'host': '127.0.0.1', 'port': 6379, 'db': 3},
    'wechat_token_lock': {'host': '127.0.0.1', 'port': 6379, 'db': 3},
    'search_dic': {'host': 'redis.paas-test.env', 'port': 6379, 'db': 3},
}
# DEFAULT_REDIS = {'host': 'test-redis', 'port': 6379, 'db': 14}
DEFAULT_REDIS = {'host': '127.0.0.1', 'port': 6379, 'db': 14}

# ====================================================================================================
# ============================================极光推送=================================================
# ====================================================================================================
BIG_PUSH_DURATION = 1
PUSH_STAT_DELAY = 60
USER_JPUSH_APP_KEY = "9e779399e200529a63722da7"
USER_JPUSH_MASTER_SECRET = "38a0a35dc8bc96b509fc61e1"
DOCTOR_JPUSH_APP_KEY = "5c450e73f736580543d0bd4e"
DOCTOR_JPUSH_MASTER_SECRET = "688b209acae48381ece1f3f8"
JPUSH_IOS_OPTIONS = {
    "apns_production": False,
}
IPHONE_USE_SANDBOX = True

# ====================================================================================================
# ============================================ES======================================================
# ====================================================================================================
ES_HOSTS = [
    {'host': '127.0.0.1', 'port': 9200}
]
ES6_HOSTS = [
    {'host': '127.0.0.1', 'port': 9200}
]

ES_V2_HOSTS = [
    {'host': '127.0.0.1', 'port': 9200}
]

TALOS_ES_HOSTS = [
    {'host': '127.0.0.1', 'port': 9200}
]
ES_INDEX_PREFIX = 'gm_test'
ES_READ_INDEX = 'gm_test_read'
ES_WRITE_INDEX = 'gm_test_write'
ES_CONSTS = {
    'TAG_ID_DIRECTOR_RECOMMEND': 1142,  # "所长精选" tag id
    'TAG_ID_POPULAR': 1202,  # "热门讨论" tag id
    'TAG_ID_POPULAR_RECOMMEND': 1203,  # "热门推荐" tag id
    'TAG_ID_DIARY_WITH_SERVICE': 1144,  # "美购日记" tag id
}
# 私信 ES
# ES_MSG_HOSTS = [{'host': 'dev-es', 'port': 9200}]
# ES_MSG_READ_INDEX = 'gm_msg_test_read'
# ES_MSG_WRITE_INDEX = 'gm_msg_test_write'
ES_MSG = {
    'order': ['db2'],
    'database': [{
        'name': 'db1',
        'es_version': 'v1',
        'hosts': [{'host': 'dev-es', 'port': 9200}],
        'table': [{
            'name': 'conversation',
            'index': 'gm_msg_test',
            'doc_type': 'conversation',
        }, {
            'name': 'message',
            'index': 'gm_msg_test',
            'doc_type': 'message',
        }]
    }, {
        'name': 'db2',
        'es_version': 'v2',
        'hosts': [
            {'host': 'es1.dev.gengmei', 'port': 9300},
        ],
        'table': [{
            'name': 'conversation',
            'index': 'gm_msg_test-conversation',
            'doc_type': 'conversation',
        }, {
            'name': 'message',
            'index': 'gm_msg_test-message',
            'doc_type': 'message',
        }]
    }, {
        'name': 'db3',
        'es_version': 'v2',
        'hosts': [
            {'host': '10.173.24.179', 'port': 9200}
        ],
        'table': [{
            'name': 'conversation',
            'index': 'gm_msg_test-conversation',
            'doc_type': 'conversation',
        }, {
            'name': 'message',
            'index': 'gm_msg_test-message',
            'doc_type': 'message',
        }]
    }]
}

# ====================================================================================================
# ==========================================DATA SYNC=================================================
# ====================================================================================================
DATA_SYNC = {
    'redis_url': 'redis://127.0.0.1:6379/15',
    'prefix': 'gaia:data-sync',
    'enqueue_table_event': True,
    'table_event_process_delay_list': [],
    'fetch_chunk_size': 1,
}

PAY_EMAIL_USER = "zhanghang@igengmei.com"

# ====================================================================================================
# =========================================ASYNC_QUEUE================================================
# ====================================================================================================
ASYNC_QUEUE = {
    'redis_url': 'redis://127.0.0.1:6379/13',
    'redis_prefix': 'test-gaia:async-queue',
    'logger_name': 'async_queue_logger',
    'check_period_seconds': 1,
    'watchdog_min_timeout': 10 * 60,
    'watchdog_max_timeout': 10 * 60,
}

# ====================================================================================================
# ==========================================分期付款===================================================
# ====================================================================================================
JIKE_URL = "http://test.geexfinance.com/merchant/service"
JIKE_SERVICE_ID = "gengmei"
JIKE_SERVICE_HASH = "3710f84987aaa4f455a10f8bbb5c55e1"
JIKE_USERID = '12369'

# ====================================================================================================
# ==========================================短信======================================================
# ====================================================================================================
UCPAAS_SID = '1e180b53a6a0f901daf1b149e2a4f152'
UCPAAS_TOKEN = '8f754ea467f6d8a4036a220686876c05'
UCPAAS_APPID = 'cd723194f6ff458092118b52c5516079'
UCPAAS_SERVER_HOST = 'https://api.ucpaas.com'
UCPAAS_SERVER_PORT = ''
UCPAAS_VERSION = '2014-06-30'
UCPAAS_TEMPID = '10862'
SMS_MODEL = 'ucpaas'
ALIDAYU_HOST = u'http://gw.api.taobao.com/router/rest'
ALIDAYU_SECRET = u'aefbeb3a8d53d9c02c379bb1bed289e1'
ALIDAYU_APPKEY = u'23401193'
ALIDAYU_SIGNNAME = u'更美APP'
DEFAULT_SMS_PLATFORM = u'alidayu'
MD_HOST = u'http://sdk.entinfo.cn:8060/webservice.asmx/mt'
MD_SN = u'SDK-BBX-010-19243'
MD_PWD = u'E5D3CF92329CA75E6B794ADE37154616'

# ====================================================================================================
# ============================================微信====================================================
# ====================================================================================================
M_WECHAT_APP_ID = 'wx5dcbb1544163c77c'
M_WECHAT_PARTNER_ID = '1284132201'
M_WECHAT_SECRET = 'e821f46be6ee45e3ca80d189f989313b'  # 不是微信的SECRET 是 pay.weixin.qq.com!!
M_WECHAT_PEM_KEY = "/srv/secret/m_apiclient_key.pem"
M_WECHAT_PEM_CERT = "/srv/secret/m_apiclient_cert.pem"

WXAPP_WECHAT_APP_ID = 'wx113018c998de9eaf'
WXAPP_WECHAT_PARTNER_ID = '1284132201'
WXAPP_WECHAT_SECRET = 'e821f46be6ee45e3ca80d189f989313b'  # 不是微信的SECRET 是 pay.weixin.qq.com!!
WXAPP_WECHAT_PEM_KEY = "/srv/secret/wechatapp_apiclient_key.pem"
WXAPP_WECHAT_PEM_CERT = "/srv/secret/wechatapp_apiclient_cert.pem"

M_WECHAT_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/test/backend/pay/wechat/notify'

CLIENT_WECHAT_APP_ID = "wx403cd28c142c7d87"
CLIENT_WECHAT_PARTNER_ID = "1302548401"
CLIENT_WECHAT_SECRET = "e821f46be6ee45e3ca80d189f989313b"
# cert
CLIENT_WECHAT_PEM_KEY = "/srv/secret/client_apiclient_key.pem"
CLIENT_WECHAT_PEM_CERT = "/srv/secret/client_apiclient_cert.pem"

# ====================================================================================================
# ============================================支付宝===================================================
# ====================================================================================================
# 支付宝网关
ALIPAY_GATEWAY = "http://wappaygw.alipay.com/service/rest.htm"
# 合作身份者ID，以2088开头的16位纯数字
ALIPAY_PARTNER = '2088211612339882'
ALIPAY_SELLER_USER_ID = ALIPAY_PARTNER
# 请求参数格式
ALIPAY_FORMAT = 'xml'
# 支付宝接口版本号
ALIPAY_VERSION = "2.0"
# 签约支付宝账号或卖家支付宝帐户
ALIPAY_SELLER_EMAIL = 'zhengxuan@wanmeizhensuo.com'
# 交易过程中服务器通知的页面 要用 http://格式的完整路径，不允许加?id=123这类自定义参数
# ALIPAY_NOTIFY_URL = 'http://wanmeizhensuo.com/alipay_notify'
# ALIPAY_NOTIFY_URL = ''
ALIPAY_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/test/backend/api/order/purchase/xml/'
ALIPAY_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/test/gateway/payment/settlement/purchase/xml/'
# 付完款后跳转的页面 要用 http://格式的完整路径，不允许加?id=123这类自定义参数
# return_url的域名不能写成http://localhost/js_php_utf8/return_url.php ，否则会导致return_url执行无效
ALIPAY_CALLBACK_URL = ""
# 网站商品的展示地址，不允许加?id=123这类自定义参数
ALIPAY_SHOW_URL = 'http://wanmeizhensuo.com'
# 签名方式 不需修改
ALIPAY_SIGN_TYPE = 'MD5'
# 字符编码格式 目前支持 GBK 或 utf-8
ALIPAY_INPUT_CHARSET = 'utf-8'
# 访问模式,根据自己的服务器是否支持ssl访问，若支持请选择https；若不支持请选择http
ALIPAY_TRANSPORT = 'http'
# MD5 密钥
ALIPAY_MD5_KEY = "2894fddi6kahmpj56n008le81gjnvdwp"
ALIPAY_SERVICE_DIRECT_TRADE_CREATE = "alipay.wap.trade.create.direct"
ALIPAY_SERVICE_AUTH_EXECUTE = "alipay.wap.auth.authAndExecute"

ALIPAY_REFUND_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/test/gateway/payment/alipay/callback/refund'
ALIPAY_CASHBACK_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/test/gateway/payment/alipay/callback/cashback'

# ===ALIPAY_APP_CONFIG===START
# https://doc.open.alipay.com/doc2/detail.htm?treeId=204&articleId=105465&docType=1
ALIPAY_APP_APP_ID = "2016051901420550"
ALIPAY_APP_SELLER_USER_ID = ALIPAY_SELLER_USER_ID
ALIPAY_APP_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/test/backend/pay/alipay/notify'
ALIPAY_APP_TIMEOUT_EXPRESS = '30m'  # "30m" "12h" "3d" "1c" (???)
# 商家的私钥
ALIPAY_APP_MY_PRIVATE_KEY = """-----BEGIN PRIVATE KEY-----
MIICXwIBAAKBgQDkGyj52wT/zQuRa1mAKwAkq09JZDCGcoBc4iLUchNvyAC8KJLTNDRMI+hA8VCsQv4s+usgvQvfjNYq4/Ryoh7mQbrVrFBc38IfPhbmNbHsczTX5+ZR8/LKcA3yNcJYbbAleFuqR89kxxo93rtBLsP0lWUn1R76MV15BOKw5UiXlwIDAQABAoGBAN2x4/ZKPqaa02ZnLhpaMI5zDOEohdz1xfoAMpfFs0xN1yEIUgMBVt61e1I69wwlJEH1MLal5bdEexY+bONI27taE5AkWb2vF3PMjt3TeyJCrxtDtq78Vxk/oXQA/9DaPz0Fa0UbDgIZPZZGVLLol3VRg88x00dRK+cQvgZ1jjhRAkEA+tSct5C/7DziNbGKf/xfKHYzciEb75Y/JF6JDdhHTHh/sDFYRspQoyEfhAqHXygRB0kiGoURlNGz/hXECKF1qQJBAOjOpz3yHyT1o3T1aUTfIZA0zT486Bj8yhiULrYqOrISQqWWXXktDnwM1JhXGgxmtCtdywCkHuiRQDT/DBvHaz8CQQC2/c2njg62hmRxz6i/Xpr9pd46cTU0QWSnX+CVHShG/dIJ9LX2TzstB8k6R4QjQ9PIgO5Ecrg03hh2UeLGeSShAkEAhYYg/bJkknogKfCnU8z2HxNptAySweIat0YmFGzcBU3b08UOD3X8HMHvHQC3++zb4ROGXvPClnjYbozpkPUrWQJBAMBZoVZtntWxD3akZBbBO9dfXktrlxagvWNWtSPnDfDsdn+qRRQr6ln4TBkLk/nDYQSiLtFzBxuyrrtCncfbcnc=
-----END PRIVATE KEY-----"""
# 支付宝针对商家的公钥
ALIPAY_APP_ALI_PUBLIC_KEY = """-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDDI6d306Q8fIfCOaTXyiUeJHkrIvYISRcc73s3vF1ZT7XN8RNPwJxo8pWaJMmvyTn9N4HQ632qJBVHf8sxHi/fEsraprwCtzvzQETrNRwVxLO5jVmRGi60j8Ue1efIlzPXV9je9mkjzOmdssymZkh2QhUrCmZYI/FCEa3/cNMW0QIDAQAB
-----END PUBLIC KEY-----"""

# 旧的回调地址
ALIPAY_APP_OLD_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/test/gateway/payment/alipay/callback'
# 旧的商家的私钥，在原有接口被废弃在之后可以删除相关的代码和这里的配置
ALIPAY_APP_OLD_MY_PRIVATE_KEY = """-----BEGIN PRIVATE KEY-----
MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALY37P8VQobI+24mwEjDV/8aAPNnS9MXJW0ZC7fnWXajJOue4X7/L+qDaWpTj/cptpFLomsl6IKAxMSefBO0CGpkjI1Oe0G9tg+Ki4Szk7CdaYNfhhRpyFwOhKiGgEKSCmboinOkc8yuD02kdSfrhzOrmN2I2KVMBjFW7V8JczN/AgMBAAECgYEAk8If3OzJaHCbacPkklxNA+B7OuTdWIvhXmk71mG0av56FtJcOlYF7d2n4n9mM19Q2tsBFm/D7ecrJ+D37iZD11vZmmwIOl5/CwOf9MUwP3ENG7S1Ax/CIZaM5MuwUs4sLXgMKaImPXq4u7UWqVuxwH+iyokXxz/uxCMf+0qFPSkCQQDc7DNZhDqh1M2ZDqhliCSP/nn8CHX6BYRIEbMQW7g1V59TOr89N8ht3FZ5b3dVItielU4dRez7o4BPYThVL6udAkEA0yaF9/BYKg9LBAPJxvnNZWu1GmabpMmawx45B4jdoTLrK+wwGPwORBIyZ+og5M0IRTW5w42ECM/Fi+KAjU82ywJAJc/jphGku2gh3G2O0vnvUBn9JO8JykZBcthcrpMUP0UFBwjKDJ9Mlckdn+E9KnwxWUsyuH3sZtGAN5XrP2FOXQJAdlUIj0LqpeecKsvUsOYd7dDG1dzbLSauzNqLK2XQjx5yHVNoQRhBBnUMOqBDfvZIxECvsqAEdsu58gMl+AuEsQJAZ6r6GHJLyQEvz5RJ8KeYnAK0FxrH76gfCPE1luLf/DVifYIopfnBbB2TczbpxEwmC1K0fk3K6HdbQnpU5o67QQ==
-----END PRIVATE KEY-----"""
# 旧的支付宝针对商家的公钥，在原有接口被废弃在之后可以删除相关的代码和这里的配置
ALIPAY_APP_OLD_ALI_PUBLIC_KEY = """-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnxj/9qwVfgoUh/y2W89L6BkRAFljhNhgPdyPuBV64bfQNN1PjbCzkIM6qRdKBoLPXmKKMiFYnkd6rAoprih3/PrQEB/VsW8OoM8fxn67UDYuyBTqA23MML9q1+ilIZwBC2AQ2UBVOrFXfFl75p6/B5KsiNG9zpgmLCUYuLkxpLQIDAQAB
-----END PUBLIC KEY-----"""

# ===ALIPAY_APP_CONFIG===END

MAIDAN_VISIBLE = True

# 买单的支付通知URL前缀，请保证最后一个字符是"/"
MAIDAN_PAY_NOTIFY_URL_BASE = "http://backend.test.igengmei.com/pay/maidan/notify/"

YINUO_SECRECT = 'kwR58f2BNLWemSmOEDsi9mJReWpHfGo8'
YINUO_USER_ID = 'KOQ6CNWM'
YINUO_CREATE_URL = 'https://api-sandbox.yinuobaoxian.com/partner/order/create'
YINUO_PAY_URL = 'https://api-sandbox.yinuobaoxian.com/partner/order/pay-balance'
YINUO_PREMIUM = 5
YINUO_PRODUCT_ID = '8YMWI5QZ'
YINUO_PLAN = 'A'
# ====================================================================================================
# ============================================Apple Pay===============================================
# ====================================================================================================
APPLEPAY_MD5_KEY = 'v99#l2*hy4omRGqp$#c5OJJ77KOK6mz^'
OID_PARTNER = '201603031000747503'
APPLEPAY_PAY_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/test/backend/pay/apple/notify'
APPLEPAY_REFUND_URL = 'https://traderapi.lianlianpay.com/refund.htm'
APPLEPAY_REFUND_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/test/backend/pay/apple/callback/refund'

# ====================================================================================================
# ============================================360生活助手==============================================
# ====================================================================================================
LIFE_360_QID = "829439411"
LIFE_360_SECRET_KEY = "kGhkO9r5FrzHmLQG"
LIFE_360_GET_MOBILE_URL = "http://profile.sj.360.cn/live/get-mobile"

# ====================================================================================================
# ============================================新浪微博=================================================
# ====================================================================================================
SINA_WEIBO_GET_UID_URL = "https://api.weibo.com/oauth2/get_token_info"

INTERNAL_EMAIL = {
    'address': 'bot@wanmeizhensuo.com',
    'host': 'smtp.exmail.qq.com',
    'username': 'bot@wanmeizhensuo.com',
    'password': 'OJi17cLf1c84c9N1af37Jja0eCvx9BI6',
}

TEST_EMAIL_LIST = [
    'wangjiabin@igengmei.com',
    'bidan@igengmei.com',
    'sunwenhui@igengmei.com',
    'guojiahua@wanmeizhensuo.com',
    'xuepengfei@wanmeizhensuo.com',
    'maruitao@wanmeizhensuo.com',
    'wangyang@wanmeizhensuo.com',
    'chenxuemei@igengmei.com',
    'wangnan@wanmeizhensuo.com',
    'wangjinlong@wanmeizhensuo.com',
    'jiaoyang@wanmeizhensuo.com',
    'zhuyufeng@wanmeizhensuo.com',
    'yangchuncheng@wanmeizhensuo.com',
    'zhaojiajun@wanmeizhensuo.com',
    'wangnan@wanmeizhensuo.com',
    'qiaojinzhu@wanmeizhensuo.com',
    'yilingxiao@wanmeizhensuo.com',
    'renshuai@wanmeizhensuo.com',
    'wangjun1@igengmei.com',
    'zhangyunyu@wanmeizhensuo.com',
    'linli@wanmeizhensuo.com',
    'lizhenghao@igengmei.com',
    'zhongchengyang@igengmei.com',
    'zhaohuatian@igengmei.com',
    'zhengdixun@igengmei.com',
    'mayan@igengmei.com',
    'yangheng@igengmei.com',
    'louchaoqi@igengmei.com',
    'liuyu@igengmei.com',
    'wangzhuxi@igengmei.com',
    'xumingming@igengmei.com',
    'mayan@igengmei.com',
    'lizexia@igengmei.com',
    'zhangweinan@igengmei.com',
]

TEST_PHONE_EMAIL_MAP = {
    '13718228007': 'zhaiguojun@wanmeizhensuo.com',
    '18601965003': 'qiaojinzhu@wanmeizhensuo.com',
    '15711434789': 'licong@wanmeizhensuo.com',
    '15811315780': 'wangyang@wanmeizhensuo.com',
    '18742441012': 'zhangyunyu@wanmeizhensuo.com',
    '18363625622': 'zhaohuatian@igengmei.com',
    '13720079874': 'zhengdixun@igengmei.com',
    '13522130504': 'wangnan@igengmei.com',
    '18610951795': 'liumiaoqi@igengmei.com',
    '18701550109': 'liuhairu@igengmei.com',
    '13716255042': 'yangheng@igengmei.com',
    '18666826943': 'nijiahua@igengmei.com',
    '18363625622': 'zhaohuatian@igengmei.com',
    '15510492564': 'mayan@igengmei.com',
    '18337157587': 'lizexia@igengmei.com',
}

TEST_PHONE_LIST = [
    '13521626466',
    '1391300267',
    '13683061063',
    '18601965003',
    '18810225027',
    '18811149976',
    '18210132873',
    '18345378781',
    '15510789751',
    '18611450809',
    '15102273250',
    '18363625622',
    '13161047169',
    '15009286557',
    '13720079874',
    '18610951795',
    '13716255042',
    '18666826943',
    '18363625622',
    '18610811754',
    '+8201024494425',
    '15010139361',
    '18858517222'
]

ANONYMOUS_USER_ID = 19634221

# 统计邮件发送帐号
STATIS_EMAIL_USER = ''
STATIS_EMAIL_PSWD = ''

DOCTOR_REFUND_TIMEOUT_MINUTES = 5

__CELERYBEAT_SCHEDULE = {
    'sms_service': {
        'task': 'api.tasks.period_task.sms_service',
        'schedule': timedelta(seconds=1200),
        'args': ()
    },
    'link_doctor': {
        'task': 'api.tasks.period_task.link_doctor',
        'schedule': timedelta(minutes=6),
        'args': ()
    },
    'share_topic_add_point': {
        'task': 'api.tasks.period_task.share_topic_add_point',
        'schedule': timedelta(minutes=30),
        'args': ()
    },
    'hospital_body_sub_items': {
        'task': 'api.tasks.period_task.hospital_body_sub_items',
        'schedule': timedelta(days=1),
        'args': ()
    },
    'update_diary_last_modified': {
        'task': 'api.tasks.period_task.update_diary_last_modified',
        'schedule': timedelta(minutes=60),
        'args': ()
    },
    'hot_in_24hrs': {
        'task': 'api.tasks.period_task.hot_in_24hrs',
        'schedule': crontab(minute=0, hour='9,12,21'),
        'args': ()
    },
    'remind_doctor_reservation': {
        'task': 'api.tasks.period_task.remind_doctor_reservation',
        'schedule': crontab(hour=20, minute=0),
        'args': (),
    },
    'allocate_stat_doctor': {
        'task': 'statistic.tasks.allocate_stat_doctor',
        'schedule': crontab(minute=50, hour=23),
        'args': ()
    },
    'remind_order_expired_before_15_days': {
        'task': 'api.tasks.period_task.remind_order_expired_before_15_days',
        'schedule': crontab(hour=14, minute=0),
        'args': (),
    },
    'mark_reply_spam': {
        'task': 'api.tasks.period_task.mark_reply_spam',
        'schedule': crontab(minute=50, hour=23),
        'args': (),
    },
    'post_order_info_to_zhida': {
        'task': 'api.tasks.period_task.post_orders_info_to_zhida',
        'schedule': crontab(minute=10, hour=0),
        'args': ()
    },
    'order_evaluate_remind': {
        'task': 'api.tasks.period_task.order_evaluate_remind',
        'schedule': timedelta(minutes=5),
        'args': ()
    },
    'doctor_refund_timeout': {
        'task': 'api.tasks.order_task.doctor_refund_timeout',
        'schedule': timedelta(minutes=5),
        'args': ()
    },
    # ##### 统计邮件 #####
    'send_conversation_stat_mail': {
        'task': 'statistic.tasks.send_conversation_stat_mail',
        'schedule': crontab(minute=10, hour=0),
        'args': ()
    },
    'send_conversation_weekly_stat_mail': {
        'task': 'statistic.tasks.send_conversation_weekly_stat_mail',
        'schedule': crontab(minute=10, hour=0, day_of_week='tue'),
        'args': ()
    },
    'get_phone_service': {
        'task': 'api.tasks.period_task.get_phone_service',
        'schedule': timedelta(minutes=10),
        'args': (),
    },
    # ##### 统计邮件 end #####
    # ##### 美购监控 #####
    'judge_services': {
        'task': 'api.tasks.service_task.judge_services',
        'schedule': crontab(minute=50, hour=11),
        'args': ()
    },
    # ##### 美购监控 end #####
    # ##### 首页推荐feed #####
    'recommend_feed': {
        'task': 'api.tasks.recommend_feed_task.recommend_feed',
        'schedule': timedelta(minutes=5),
        'args': (),
    },
    # ##### 首页最新feed #####
    'newest_feed': {
        'task': 'api.tasks.recommend_feed_task.newest_feed',
        'schedule': timedelta(minutes=5),
        'args': (),
    },
    'remind_coupon_expire': {
        'task': 'api.tasks.period_task.remind_coupon_expire',
        'schedule': crontab(minute=0, hour=10),
        # 'schedule': timedelta(minutes=5),
        'args': (),
    },
    # repurchase reminder
    'repurchase_reminder': {
        'task': 'api.tasks.period_task.repurchase_reminder',
        'schedule': timedelta(minutes=30),
        'args': (),
    },
    # recovery reminder
    'recovery_reminder': {
        'task': 'api.tasks.recovery_reminder_task.daily_recovery_reminder',
        'schedule': crontab(minute=0, hour=20),
        'args': (),
    },
    'period_stock_alert': {
        'task': 'pay.tasks.alter_task.period_stock_alert',
        # 'schedule': crontab(minute=0, hour='0,8,16'),
        'schedule': timedelta(minutes=180),
        'args': ()
    },
    # seckill notify
    'seckill_notify': {
        'task': 'api.tasks.period_task.seckill_notify',
        'schedule': timedelta(minutes=2),
        'args': (),
    },
    'create_sleep_user_to_redis': {
        'task': 'api.tasks.user_related_tasks.create_sleep_user_to_redis',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    # 计算医生的收入分
    'calc_doctor_discount_one_day': {
        'task': 'api.tasks.order_task.calc_doctor_discount_one_day',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'get_day_smart_rank': {
        'task': 'api.tasks.period_task.get_day_smart_rank',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    # 轮训七牛转码状态
    'check_water_mark_video_is_finish': {
        'task': 'api.tasks.live_task.check_water_mark_video_is_finish',
        'schedule': timedelta(seconds=60),
        'args': (),
    },
    # 轮训七牛转码状态（美购视频）
    'check_water_mark_video_is_finish_service': {
        'task': 'api.tasks.service_task.check_water_mark_video_is_finish_service',
        'schedule': timedelta(seconds=60),
        'args': (),
    },
    'save_replay_url': {
        'task': 'api.tasks.live_task.save_replay_url',
        'schedule': timedelta(minutes=30),
        'args': (),
    },
    # 生成直播回放帖子
    'check_live_status': {
        'task': 'api.tasks.live_task.check_live_status',
        'schedule': timedelta(minutes=2),
        'args': (),
    },
    'get_tag_top_sale_service': {
        'task': 'api.tasks.period_task.get_tag_top_sale_service',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'add_fake_vote_num_list': {
        'task': 'api.tasks.live_task.add_fake_vote_num_list',
        'schedule': timedelta(minutes=1),
        'args': (),
    }
    # 统计crash相关关键字帖子
    # 'crash_checkout': {
    #    'task': 'api.tasks.crash_checkout.crash_check',
    #   'schedule': timedelta(hours=1),
    #  'args': (),
    # },
}

ORDER_EVALUATE_REMIND_TIME = 1

HERA_EMAIL_USER = 'doctor@wanmeizhensuo.com'
HERA_EMAIL_PSWD = 'xl60QkFtwJq6ziswn2a4r4pkFNozI13g'

ORDER_ARBIT_TIMEOUT_DELTA = 1

BOSS = 22

SETTLEMENT_SOFT_TIMEOUT = 18000
SETTLEMENT_HARD_TIMEOUT = 72000

# add by chuncheng 5.8
PAY_EMAIL_USER = 'alert@igengmei.com'
PAY_EMAIL_USER_PWD = 'X10pfvq0uxhnky4iyvuqgz9jqetvba3U'
PAY_EMAIL_STOCK_ALTER_LIST = ['yangchuncheng@igengmei.com']
PAY_EMAIL_KAITUAN_ALTER_LIST = ['yangchuncheng@igengmei.com']
PAY_EMAIL_REFUND_ALERT_LIST = ['linli@igengmei.com']

# add by huazhu 5.8
TAG_BLACK_LIST = [971, 929, 10, 13, 2214]

BACKEND_API_HOST = 'http://backend.test.env'

PAY_EMAIL_STATEMENT_ALERT_LIST = []

# 400
CUSTOM_SERVICE_PHONE_API_ENDPOINT = 'http://222.73.121.26:8888/transfer/dealData.do'
CUSTOM_SERVICE_PHONE_API_ID = 'gmTest'
CUSTOM_SERVICE_PHONE_API_PASS = 'test'

# SENTRY_CELERY_ENDPOINT = 'http://c5b4ede52bc6452182565b529735a090:0324e8fff118445a9b38576213b8e759@sentry.igengmei.com/120'
SENTRY_CELERY_ENDPOINT = ''

STOCK_ALERT_THRESHOLD = 3

QINIU_ACCESS_KEY = "UPCOYIJkZOMcdd9FDzpBqYjzWUh55fBpVi3AhWpL"
QINIU_SECRET_KEY = "z5YvpDDSam_JE345Z8J_f3TufzelOW2VOGNoBl9e"

FEATURE_BASE_URL = 'http://backend.test.igengmei.com/hybrid/csc/'

PUSH_NOTIFICATION_AFTER_FOLLOW_USER = True

UCPASS_DAILY_LIMIT = 5000
MAX_LOGIN_ATTEMPTES = 5000

YINGTZ_KEY_TEST = '/srv/secret/yingtz_key_test.pem'
YINGTZ_KEY_PROD = '/srv/secret/yingtz_key_prod.pem'
GMEI_PRIVATE_KEY_PKCS8 = '/srv/secret/gmei_private_key_pkcs8.pem'
YINGTZ_KEY = YINGTZ_KEY_TEST
XYMD5KEY = bytearray('74ba4d7ad1d5bc705e6c96bbf599c3f1', encoding='utf8')
QINIU_ACCESS_KEY = "UPCOYIJkZOMcdd9FDzpBqYjzWUh55fBpVi3AhWpL"
QINIU_SECRET_KEY = "z5YvpDDSam_JE345Z8J_f3TufzelOW2VOGNoBl9e"

XIAOYING_EXCEPTION_STATUS_EMAIL_LIST = [
    'dingyingcai@igengmei.com',
]

NO_REPLY_EMAIL = {
    'address': 'no-reply@igengmei.com',
    'host': 'smtp.exmail.qq.com',
    'username': 'no-reply@igengmei.com',
    'password': 'MErs@bfL85Gkwkxt554w',
}

GROUPON_SERVICE_IDS = (5269672, 4667667)

DEFAULT_TAG_ATTR_ID = 1

# weixin js sdk
# 正式账号
WX_APP_ID = 'wx19c0bdd0c9e25acb'
WX_APP_SECRET = '41855cb5fd32338435b2c7dbaa400716'
WX_USER_ID = 20889703

MAIDAN_SOFT_TIMEOUT = 6400
MAIDAN_HARD_TIMEOUT = 3600
DOUBLE_EVELEN_SPECIAL = [435]

# CUSTOM_SERVICE_PHONE_NEW = '4006999227'
# CUSTOM_SERVICE_PHONE = '4006999227'

CUSTOM_SERVICE_PHONE_NEW = '4006899900'
CUSTOM_SERVICE_PHONE = '4006899900'
DEFAULT_400_VENDOR = 'xtwy'

ZTTH_CONF = {
    'account': '01059658065',
    'user': '6016122201',
    'passwd': '88908afc672f0b599ae75b7552129a33',
    'api_domain': 'http://m.icsoc.net/',
}

DEFAULT_ZONE_ICON = 'http://hera.s.igengmei.com/circleicon/2016/11/21/a699396589'

SHOW_V = False
YUNPIAN_API_KEY = '89eea91e59166314eea3d62f2912e5a9'
YUNPIAN_HOST = 'https://sms.yunpian.com'

# Jiahua Guo
SMS_USE_SEPERATED_SERVICE = True
OPEN_RESYS = True

LIVE_MSG_REDIS_FLAG = True

QINIU_LIVE_TIMEOUT = 86400

SEND_MSG_TIME = 6
# TALOS_RPC_CACHE = {'host': 'test-redis', 'port': 6379, 'db': 14}
TALOS_RPC_CACHE = {'host': '127.0.0.1', 'port': 6379, 'db': 14}

DOCTOR_BUSINESS_CHANNAL_ID = 51

DOCTOR_USER_CAN_SEND_MSG = [
    22,
    23,
]

FENGXIANGGOU_COUPONGIFT_NEW_USER_GIFT_ID = 210
FENGXIANGGOU_COUPONGIFT_NEW_USER_CHANNEL_ID = 64

FENGXIANGGOU_COUPONGIFT_OLD_USER_GIFT_ID = 211
FENGXIANGGOU_COUPONGIFT_OLD_USER_CHANNEL_ID = 64
USE_DOC = True
TEMPLATES += [
    {
        'BACKEND': 'django.template.backends.jinja2.Jinja2',
        'APP_DIRS': True,
    },
]

REPLIES_READ_MYSQL_FLAG = True

DATA_TRANSFER_MARS_API_HOST = 'mars.test.gengmei.cc'
MULTI_TOPIC_TAG_ID = 5089

REMIND_USER_WRITE_DIARY_AFTER_ORDER_VALIDATE_DAYS = 0
REMIND_USER_WRITE_DIARY_AFTER_ORDER_VALIDATE_HOURS = 17
REMIND_USER_WRITE_DIARY_AFTER_ORDER_VALIDATE_MINUTES = 15
DBMW_LOGICAL_DATABASE_ID = 'zhengxing_test'
MIMAS_LOGICAL_DATABASE_ID = 'mimas_test'
QINIU_HUB_NAME = u'igengmei-live-test'

PUSH_FOR_SHOPCART_CHANNEL_ID = 87
PUSH_FOR_SHOPCART_GIFT_ID_AND_PERCENT = [(266, 10), (267, 7), (268, 3), (269, 20), (270, 20), (271, 20),
                                         (272, 20)]  # GiftId, Percent
# 推送限制
PUSH_TOTAL_LIMIT = 100  # 推送限制总条数
# 各子类限制的条数,注意：子类限制数要小于总数
PUSH_SUB_LIMIT = 100

SPECIAL_SHOW_COUPON_GIFT_IDS = [374]

POINT_MALL_LOTTERY_NOTHING_NUMBER = 35
POINT_MALL_LOTTERY_TRY_AGAIN_NUMBER = 50

ASYNC_TRIGGER_RECIEVE = False

SECKILL_NEW_SEPARATED_SERVICE = True
SECKILL_NEW_SEPARATED_HOSPITAL = True

import pymysql

YIBAO_MERCHANTNO = '10000466938'
YIBAO_APP_KEY = 'OPR:10000466938'
YIBAO_AES_SECRET_KEY = '10000466938'
YIBAO_NOTIFY_URL = 'http://exchange.env.wanmeizhensuo.com/payment/yee/callback'
YIBAO_REDIRECT_RUL = 'http://doctor.paas.env/ad_recharge'
YIBAO_SERVER_ROOT = 'https://openapi.yeepay.com/yop-center'
YIBAO_PUBLIC_KEY = """-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6p0XWjscY+gsyqKRhw9MeLsEmhFdBRhT2emOck/F1Omw38ZWhJxh9kDfs5HzFJMr
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6p0XWjscY+gsyqKRhw9MeLsEmhFdBRhT2emOck/F1Omw38ZWhJxh9kDfs5HzFJMr
-----END PUBLIC KEY-----
"""

YIBAO_PRIVATE_KEY = """-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDKLgI+64mmJdNg1TwlCPBnNH3b3qfw2TdHVc2uDd4LTyQI8nRr0heFhhdj
-----END PRIVATE KEY-----                   
"""

YIBAO_API = {
    'token_uri': '/rest/v1.0/std/trade/order',
    'cashier': 'https://cash.yeepay.com/cashier/std'
}
