# coding=utf-8
import datetime
import json
from multiprocessing import Manager, Pool

from django.core.management import BaseCommand

from api.models import UserExtra
from rpc.cache import sleep_action_fans_cache
from rpc.cache import sleep_noaction_fans_cache

manager = Manager()
action_user = manager.list()
no_action_user = manager.list()


def calc_user_extra(user_extra):
    try:
        user = user_extra.user
        topic_count = int(user.person.topic_count)
        if topic_count > 0:
            action_user.append(user.id)
        else:
            no_action_user.append(user.id)
        print user.id
    except:
        print 'error'
        pass


class Command(BaseCommand):
    def handle(self, *args, **options):
        user_extras = UserExtra.objects.filter(last_login__lt=datetime.datetime(2015, 1, 1))

        pool = Pool(processes=4)
        pool.map(calc_user_extra, user_extras)
        pool.close()
        pool.join()

        sleep_action_fans_cache.set('sleep_user', json.dumps(list(action_user)))
        sleep_noaction_fans_cache.set('sleep_user', json.dumps(list(no_action_user)))
