# coding=utf-8

# coding=utf-8
import tablib
from django.core.management import BaseCommand
from gm_types.gaia import YINUO_TYPE, TAG_TYPE, ZONE_TYPE_V2

from api.models import Zone


class Command(BaseCommand):
    """
    设置一诺保险默认的美购
    python manage.py change_zone_type
    """

    def handle(self, *args, **options):
        dt_result = tablib.Dataset()
        dt_result.headers = [u'圈子ID', u'tag类型', u'圈子类型']
        zones = Zone.objects.all()
        for zone in zones:
            try:
                if zone.tag.tag_type == TAG_TYPE.FREE:
                    zone.zone_type = ZONE_TYPE_V2.ACTIVITY_ZONE
                else:
                    zone.zone_type = ZONE_TYPE_V2.NORMAL_ZONE
                zone.save()
                row = [zone.id, TAG_TYPE.getDesc(zone.tag.tag_type), ZONE_TYPE_V2.getDesc(zone.zone_type)]
                print zone.id
                dt_result.append(row)
            except Exception as e:
                print e.message
                continue
        open(u'/data/zone/zone.xlsx', 'wb').write(dt_result.xlsx)
        print('Done!')
