# -*- coding: UTF-8 -*-

from django.db.models import Q, F
from api.models.order import Order
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from api.models.assist import AssistPrize, AssistCode
from gm_types.gaia import TAG_TYPE
from datetime import timedelta
from gm_dataquery.db import DB


class AssistprizeDB(DataBuilder):
    def getval_surplus_num(self, obj):
        return obj.stock - obj.consume_count

    def getval_description(self, obj, need_escape=False):
        return obj.description

@DB
class AssistprizeDQ(DataSQLQuery):
    model = AssistPrize
    data_model = AssistprizeDB


class AssistcodeDB(DataBuilder):
    def getval_is_successr(self, obj):
       return u'是' if obj.suc_count >= obj.assistprize.assist_num else u'否'


@DB
class AssistcodeDQ(DataSQLQuery):
    model = AssistCode
    data_model = AssistcodeDB
