# -*- coding: UTF-8 -*-

from __future__ import absolute_import
from django.db.models import Q
from gm_types.doctor import DOCTOR_REGISTER_STATUS

from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from doctor.models import DoctorRegister


class DoctorRegisterDB(DataBuilder):
    def getval_status(self, obj):
        return DOCTOR_REGISTER_STATUS.getDesc(obj.status)

    def getval_merchant(self, obj):
        return u'是' if obj.is_merchant else u'否'


@DB
class DoctorRegisterDQ(DataSQLQuery):
    model = DoctorRegister
    data_model = DoctorRegisterDB

    def filter_add_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_created_at(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    # def filter_status(self, srch_key, srch_val, regex=False):
    #     if srch_val == '':
    #         return None
    #     else:
    #         return Q(status__in=srch_val)

    def filter_area_type(self, srch_key, srch_val, regex=False):
        if srch_val == '':
            return None
        else:
            return Q(area_type__in=srch_val)
