-- Deploy gaia:api_2016_11_17_sku_1 to mysql

BEGIN;

ALTER TABLE `api_serviceitem`
ADD COLUMN `total_num` integer NOT NULL DEFAULT 0,
ADD COLUMN `sku_stock` integer NOT NULL DEFAULT 0,
ADD COLUMN `sku_stock_lte_zero` bool NOT NULL DEFAULT 1;

ALTER TABLE `api_order`
ADD COLUMN `service_item_id` integer,
ADD COLUMN `service_item_price_id` integer,
ADD COLUMN `activity_type` integer NULL DEFAULT NULL,
ADD COLUMN `activity_id` varchar(50) NULL DEFAULT NULL;

ALTER TABLE `pay_servicesnapshot`
ADD COLUMN `price_info` longtext NULL DEFAULT NULL,
ADD COLUMN `rich_text` longtext NULL DEFAULT NULL,
ADD COLUMN `coupon_id` integer NULL DEFAULT NULL,
ADD COLUMN `coupon_info_id` integer NULL DEFAULT NULL,
ADD COLUMN `coupon_name` varchar(15) NULL DEFAULT NULL,
ADD COLUMN `coupon_value` double precision NULL DEFAULT NULL,
ADD COLUMN `payment_without_coupon` double precision NULL DEFAULT NULL;

ALTER TABLE `api_seckillnotify` ADD COLUMN `special_item_id` integer NULL;

ALTER TABLE `api_seckillnotify` ADD CONSTRAINT `person_id_special_item_id` UNIQUE (`special_item_id`, `person_id`);

ALTER TABLE `api_seckillnotify` ADD CONSTRAINT `special_item_id_refs_id_51556671` FOREIGN KEY (`special_item_id`) REFERENCES `api_specialitem` (`id`);

ALTER TABLE `api_specialitem`
ADD COLUMN `tip` varchar(128) NOT NULL;

CREATE TABLE `api_skupricerule` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(100) NOT NULL,
    `is_enable` bool NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `activity_type` integer NOT NULL,
    `activity_id` varchar(50) NOT NULL,
    `refund_anytime` bool,
    `can_use_points` bool,
    `share_get_cashback` bool
);

CREATE TABLE `api_serviceitemprice` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `service_item_id` integer NOT NULL,
    `is_enable` bool NOT NULL,
    `sale_limit` integer NOT NULL DEFAULT 0,
    `sale_limit_lte_zero` bool NOT NULL DEFAULT 1,
    `is_default_price` bool NOT NULL,
    `selling_rule_id` integer,
    `discount` integer NOT NULL,
    `pre_payment_price` integer NOT NULL,
    `original_price` integer NOT NULL,
    `gengmei_price` integer NOT NULL,
    `cash_back_rate` integer NOT NULL,
    `cash_back_fee` integer NOT NULL,
    `self_support_discount` integer NOT NULL,
    `single_user_buy_limit` integer NOT NULL
);

ALTER TABLE `api_serviceitemprice` ADD CONSTRAINT `selling_rule_id_refs_id_e9394464` FOREIGN KEY (`selling_rule_id`) REFERENCES `api_skupricerule` (`id`);
ALTER TABLE `api_serviceitemprice` ADD CONSTRAINT `service_item_id_refs_id_acdf084d` FOREIGN KEY (`service_item_id`) REFERENCES `api_serviceitem` (`id`);

COMMIT;