# coding=utf-8
import tablib
from django.core.management import BaseCommand

from api.models import SpecialItem


class Command(BaseCommand):
    def handle(self, *args, **options):
        special_ids = [696, 697, 698, 699, 700, 702, 704, 710, 712, 713, 714, 715, 716, 723, 724, 725, 726, 727, 728,
                       729, 730, 731, 732, 733, 734, 735, 736, 737, 738, 739, 740, 741, 742]
        dt_result = tablib.Dataset()
        dt_result.headers = [u'美购ID', u'原更美价', u'原预付款', u'新更美价', u'新预付款']
        specialitems = SpecialItem.objects.filter(special_id__in=special_ids)
        for specialitem in specialitems:
            serviceitems_ = specialitem.service.items.filter(is_delete=False)
            if (not specialitem.service.is_multiattribute) and serviceitems_.count() == 1:
                row = []
                row.append(specialitem.service.id)
                row.append(specialitem.service.gengmei_price)
                row.append(specialitem.service.pre_payment_price)
                row.append(serviceitems_[0].gengmei_price)
                row.append(serviceitems_[0].pre_payment_price)

                specialitem.service.gengmei_price = serviceitems_[0].gengmei_price
                specialitem.service.pre_payment_price = serviceitems_[0].pre_payment_price
                specialitem.service.save()
                dt_result.append(row)
                print specialitem.service.id

        open(u'/data/hospital/result_service_end.xlsx', 'wb').write(dt_result.xlsx)
