# -*- coding: UTF-8 -*-
from django.db.models import Q

from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from api.models.doctor import Agreement
from gm_types.gaia import AGREEMENT_TYPE
from gm_dataquery.db import DB
import datetime


class AgreementDB(DataBuilder):
    def getval_status(self, obj):
        if obj.status == AGREEMENT_TYPE.DEFAULT:
            return u'未上线'
        elif obj.status == AGREEMENT_TYPE.IS_RECALL:
            return u'已撤回'
        elif obj.status == AGREEMENT_TYPE.IS_ONLINE:
            if obj.send_time > datetime.datetime.now():
                return u'未上线'
            else:
                return u'已上线'


@DB
class AgreementDQ(DataSQLQuery):
    model = Agreement
    data_model = AgreementDB
