# coding=utf-8

import xlrd
from gm_types.gaia import WORDREL_CATEGORY
from django.core.management import BaseCommand
from api.models import WordRel, WordRelSynonym


class Command(BaseCommand):
    """
    python manage.py insert_20181211_add_wordrel
    """

    def handle(self, *args, **options):
        data = xlrd.open_workbook('wordrel.xlsx'.decode('utf-8'))
        wordrel_category = [WORDREL_CATEGORY.ORG, WORDREL_CATEGORY.DOCTOR, WORDREL_CATEGORY.CITY]
        for i, table in enumerate(data.sheets()[:3]):
            for row in range(1, table.nrows):
                r = table.row_values(row)
                keyword = r[0]
                try:
                    obj, _ = WordRel.objects.get_or_create(keyword=keyword, category=wordrel_category[i])
                    s_obj, _ = WordRelSynonym.objects.get_or_create(wordrel=obj, word=keyword)
                except:
                    print 'error', keyword, wordrel_category
        print 'Done!'
