# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_types.gaia import HERA_OPERATE_LOG_PACKAGE

from api.tool.user_tool import get_user_from_context
from hera.queries.log import LogDQ
from ..models import UserPerm
from rpc.decorators import bind_context


uri_pre = 'hera/log'



@bind_context(uri_pre+'/service_list')
def service_datatable(ctx, options):
    user = get_user_from_context(ctx)
    q = Q(package_new=HERA_OPERATE_LOG_PACKAGE.SERVICE)


    if not user.is_superuser:
        members = UserPerm.members(user)
        q &= Q(user__in=members)

    dtobj = LogDQ(init_q=q)
    return dtobj.process(**options)


@bind_context(uri_pre+'/order_list')
def order_datatable(ctx, options):
    user = get_user_from_context(ctx)
    q = Q(package_new=HERA_OPERATE_LOG_PACKAGE.ORDER_MANAGEMENT)
    if not user.is_superuser:
        members = UserPerm.members(user)
        q &= Q(user__in=members)
    dtobj = LogDQ(init_q=q)
    return dtobj.process(**options)



@bind_context(uri_pre + '/action_list')
def diary_query(ctx, options):
    dqobj = LogDQ()
    return dqobj.process(**options)
