# # coding=utf-8
# from __future__ import absolute_import, unicode_literals
# from rpc.decorators import bind_context
# from rpc.tool.error_code import gen
# from rpc.tool.error_code import CODES
# from api.tool.user_tool import get_user_from_context
# from api.models import RefundOrder
# from api.models import ORDER_OPERATION_TYPE
# from api.models import ORDER_OPERATION_ROLE
#
#
# @bind_context('hera/refund/approve', login_required=True)
# def hera_refund_agree(ctx, refund_order_id):
#     user = get_user_from_context(ctx)
#     try:
#         refund = RefundOrder.objects.get(pk=refund_order_id)
#     except RefundOrder.DoesNotExist:
#         raise gen(CODES.ORDER_CAN_NOT_REFUND)
#     refund.order.operate(user.person, ORDER_OPERATION_TYPE.ARBIT_APPROVE, ORDER_OPERATION_ROLE.STAFF)
#     refund.save()
#
#     try:
#         ctx.rpc['pay/unified/refund'](order_id=refund.order_id).unwrap()
#     except:
#         # 正常情况下, 医生退款, 肯定能退.
#         # 如果不能, 则为异常情况
#         # 异常情况, 不可干扰医生退款流程.
#         pass
#
#
# @bind_context('hera/refund/reject', login_required=True)
# def hera_refund_reject(ctx, refund_order_id):
#     user = get_user_from_context(ctx)
#     try:
#         refund = RefundOrder.objects.get(pk=refund_order_id)
#     except RefundOrder.DoesNotExist:
#         raise gen(CODES.ORDER_CAN_NOT_REFUND)
#     refund.order.operate(user.person, ORDER_OPERATION_TYPE.ARBIT_REJECT, ORDER_OPERATION_ROLE.STAFF)
#     refund.save()
