# coding:utf-8

"""上传oneimage数据""""""下载oneimage数据"""

import time

from django.core.management.base import BaseCommand
from django.db.models import Q

from utils.execel import ExcelReader
from rpc.tool.log_tool import logging_exception
from api.models.beauty_topic import MotherWord, BeautyPhoto, MotherwordPhotoRelated



class Command(BaseCommand):

    help = '下载oneimage数据'

    def handle(self, *args, **options):

        print('------ starting -----')
        start_time = time.time()
        print("start at: ", start_time)

        excel = ExcelReader("./oneimage.xlsx")

        excel.sheet_select_by_name("api_motherword")
        for row in range(excel.row_number):
            data = excel.read_row(row)
            MotherWord.objects.create(
                id=data[0],
                name=data[1],
                gender=data[2],
                content_ad=data[3],
                is_online=data[4],
            )

        excel.sheet_select_by_name("api_beautyphoto")
        for row in range(excel.row_number):
            data = excel.read_row(row)
            BeautyPhoto.objects.create(
                id=data[0],
                role_name=data[1],
                url=data[2],
                gender=data[3],
                is_online=data[4],
            )

        excel.sheet_select_by_name("api_motherwordphotorelated")
        for row in range(excel.row_number):
            data = excel.read_row(row)
            try:
                MotherwordPhotoRelated.objects.create(
                    id=data[0],
                    beautyphoto_id=data[1],
                    motherword_id=data[2],
                )
            except:
                logging_exception()

        end_time = time.time()
        print("end at: ", end_time)
        print('total use {} s.'.format(end_time - start_time))
        print('Done!')
