#! -*- coding: utf-8 -*-
import hashlib
import hmac
import base64

def hash_hmac(key, content, digestmod=hashlib.sha1, raw_output=True, base64encode=True):
    myhmac = hmac.new(key, content, digestmod)
    if raw_output:
        myhmac = myhmac.digest()
    else:
        myhmac = myhmac.hexdigest()

    if base64encode:
        myhmac = base64.b64encode(myhmac)
    return myhmac

