# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

import datetime

from api.models import UserExtra
from api.tool.user_tool import get_user_from_context
from rpc.decorators import bind_context


@bind_context("api/alert/rating", login_required=True)
def alert_rating(ctx, click_btn):
    user = get_user_from_context(ctx)
    user_extra, created = UserExtra.objects.get_or_create(user=user)
    if created:
        user_extra.save()
    user_extra.rating_click = click_btn
    user_extra.last_alert_rating_time = datetime.datetime.now()
    user_extra.save()
    return None
